/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Arrays;
import java.util.Collection;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;

public class CommonComponents {
    public static final IChatBaseComponent EMPTY = IChatBaseComponent.empty();
    public static final IChatBaseComponent OPTION_ON = IChatBaseComponent.translatable("options.on");
    public static final IChatBaseComponent OPTION_OFF = IChatBaseComponent.translatable("options.off");
    public static final IChatBaseComponent GUI_DONE = IChatBaseComponent.translatable("gui.done");
    public static final IChatBaseComponent GUI_CANCEL = IChatBaseComponent.translatable("gui.cancel");
    public static final IChatBaseComponent GUI_YES = IChatBaseComponent.translatable("gui.yes");
    public static final IChatBaseComponent GUI_NO = IChatBaseComponent.translatable("gui.no");
    public static final IChatBaseComponent GUI_PROCEED = IChatBaseComponent.translatable("gui.proceed");
    public static final IChatBaseComponent GUI_BACK = IChatBaseComponent.translatable("gui.back");
    public static final IChatBaseComponent GUI_ACKNOWLEDGE = IChatBaseComponent.translatable("gui.acknowledge");
    public static final IChatBaseComponent CONNECT_FAILED = IChatBaseComponent.translatable("connect.failed");
    public static final IChatBaseComponent NEW_LINE = IChatBaseComponent.literal("\n");
    public static final IChatBaseComponent NARRATION_SEPARATOR = IChatBaseComponent.literal(". ");
    public static final IChatBaseComponent ELLIPSIS = IChatBaseComponent.literal("...");

    public static IChatMutableComponent days(long var0) {
        return IChatBaseComponent.translatable("gui.days", var0);
    }

    public static IChatMutableComponent hours(long var0) {
        return IChatBaseComponent.translatable("gui.hours", var0);
    }

    public static IChatMutableComponent minutes(long var0) {
        return IChatBaseComponent.translatable("gui.minutes", var0);
    }

    public static IChatBaseComponent optionStatus(boolean var0) {
        return var0 ? OPTION_ON : OPTION_OFF;
    }

    public static IChatMutableComponent optionStatus(IChatBaseComponent var0, boolean var1) {
        return IChatBaseComponent.translatable(var1 ? "options.on.composed" : "options.off.composed", var0);
    }

    public static IChatMutableComponent optionNameValue(IChatBaseComponent var0, IChatBaseComponent var1) {
        return IChatBaseComponent.translatable("options.generic_value", var0, var1);
    }

    public static IChatMutableComponent joinForNarration(IChatBaseComponent var0, IChatBaseComponent var1) {
        return IChatBaseComponent.empty().append(var0).append(NARRATION_SEPARATOR).append(var1);
    }

    public static IChatBaseComponent joinLines(IChatBaseComponent ... var0) {
        return CommonComponents.joinLines(Arrays.asList(var0));
    }

    public static IChatBaseComponent joinLines(Collection<? extends IChatBaseComponent> var0) {
        return ChatComponentUtils.formatList(var0, NEW_LINE);
    }
}

