/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder
extends ByteToMessageDecoder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EnumProtocolDirection flow;

    public PacketDecoder(EnumProtocolDirection var0) {
        this.flow = var0;
    }

    protected void decode(ChannelHandlerContext var0, ByteBuf var1, List<Object> var2) throws Exception {
        int var3 = var1.readableBytes();
        if (var3 == 0) {
            return;
        }
        PacketDataSerializer var4 = new PacketDataSerializer(var1);
        int var5 = var4.readVarInt();
        Packet<?> var6 = ((EnumProtocol)((Object)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get())).createPacket(this.flow, var5, var4);
        if (var6 == null) {
            throw new IOException("Bad packet id " + var5);
        }
        int var7 = ((EnumProtocol)((Object)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get())).getId();
        JvmProfiler.INSTANCE.onPacketReceived(var7, var5, var0.channel().remoteAddress(), var3);
        if (var4.readableBytes() > 0) {
            throw new IOException("Packet " + ((EnumProtocol)((Object)var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get())).getId() + "/" + var5 + " (" + var6.getClass().getSimpleName() + ") was larger than I expected, found " + var4.readableBytes() + " bytes extra whilst reading packet " + var5);
        }
        var2.add(var6);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(NetworkManager.PACKET_RECEIVED_MARKER, " IN: [{}:{}] {}", new Object[]{var0.channel().attr(NetworkManager.ATTRIBUTE_PROTOCOL).get(), var5, var6.getClass().getName()});
        }
    }
}

