/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagList
extends NBTList<NBTBase> {
    private static final int SELF_SIZE_IN_BYTES = 37;
    public static final NBTTagType<NBTTagList> TYPE = new NBTTagType.b<NBTTagList>(){

        @Override
        public NBTTagList load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            var2.accountBytes(37L);
            if (var1 > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte var3 = var0.readByte();
            int var4 = var0.readInt();
            if (var3 == 0 && var4 > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            var2.accountBytes(4L * (long)var4);
            NBTTagType<?> var5 = NBTTagTypes.getType(var3);
            ArrayList var6 = Lists.newArrayListWithCapacity((int)var4);
            for (int var7 = 0; var7 < var4; ++var7) {
                var6.add(var5.load(var0, var1 + 1, var2));
            }
            return new NBTTagList(var6, var3);
        }

        /*
         * Exception decompiling
         */
        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 4[SWITCH]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void skip(DataInput var0) throws IOException {
            NBTTagType<?> var1 = NBTTagTypes.getType(var0.readByte());
            int var2 = var0.readInt();
            var1.skip(var0, var2);
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private final List<NBTBase> list;
    private byte type;

    NBTTagList(List<NBTBase> var0, byte var1) {
        this.list = var0;
        this.type = var1;
    }

    public NBTTagList() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        var0.writeByte(this.type);
        var0.writeInt(this.list.size());
        for (NBTBase var2 : this.list) {
            var2.write(var0);
        }
    }

    @Override
    public int sizeInBytes() {
        int var0 = 37;
        var0 += 4 * this.list.size();
        for (NBTBase var2 : this.list) {
            var0 += var2.sizeInBytes();
        }
        return var0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public NBTTagType<NBTTagList> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    @Override
    public NBTBase remove(int var0) {
        NBTBase var1 = this.list.remove(var0);
        this.updateTypeAfterRemove();
        return var1;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public NBTTagCompound getCompound(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 10) {
            return (NBTTagCompound)var1;
        }
        return new NBTTagCompound();
    }

    public NBTTagList getList(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 9) {
            return (NBTTagList)var1;
        }
        return new NBTTagList();
    }

    public short getShort(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 2) {
            return ((NBTTagShort)var1).getAsShort();
        }
        return 0;
    }

    public int getInt(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 3) {
            return ((NBTTagInt)var1).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 11) {
            return ((NBTTagIntArray)var1).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 11) {
            return ((NBTTagLongArray)var1).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 6) {
            return ((NBTTagDouble)var1).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int var0) {
        NBTBase var1;
        if (var0 >= 0 && var0 < this.list.size() && (var1 = this.list.get(var0)).getId() == 5) {
            return ((NBTTagFloat)var1).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int var0) {
        if (var0 < 0 || var0 >= this.list.size()) {
            return "";
        }
        NBTBase var1 = this.list.get(var0);
        if (var1.getId() == 8) {
            return var1.getAsString();
        }
        return var1.toString();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public NBTBase get(int var0) {
        return this.list.get(var0);
    }

    @Override
    public NBTBase set(int var0, NBTBase var1) {
        NBTBase var2 = this.get(var0);
        if (!this.setTag(var0, var1)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", var1.getId(), this.type));
        }
        return var2;
    }

    @Override
    public void add(int var0, NBTBase var1) {
        if (!this.addTag(var0, var1)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", var1.getId(), this.type));
        }
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        if (this.updateType(var1)) {
            this.list.set(var0, var1);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        if (this.updateType(var1)) {
            this.list.add(var0, var1);
            return true;
        }
        return false;
    }

    private boolean updateType(NBTBase var0) {
        if (var0.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = var0.getId();
            return true;
        }
        return this.type == var0.getId();
    }

    @Override
    public NBTTagList copy() {
        List<NBTBase> var0 = NBTTagTypes.getType(this.type).isValue() ? this.list : Iterables.transform(this.list, NBTBase::copy);
        ArrayList var1 = Lists.newArrayList(var0);
        return new NBTTagList(var1, this.type);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagList && Objects.equals(this.list, ((NBTTagList)var0).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitList(this);
    }

    @Override
    public byte getElementType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        switch (var0.visitList(NBTTagTypes.getType(this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.b.HALT;
            }
            case BREAK: {
                return var0.visitContainerEnd();
            }
        }
        block13: for (int var1 = 0; var1 < this.list.size(); ++var1) {
            NBTBase var2 = this.list.get(var1);
            switch (var0.visitElement(var2.getType(), var1)) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                default: {
                    switch (var2.accept(var0)) {
                        case HALT: {
                            return StreamTagVisitor.b.HALT;
                        }
                        case BREAK: {
                            return var0.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return var0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    @Override
    public /* synthetic */ Object remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ void add(int n2, Object object) {
        this.add(n2, (NBTBase)object);
    }

    @Override
    public /* synthetic */ Object set(int n2, Object object) {
        return this.set(n2, (NBTBase)object);
    }

    @Override
    public /* synthetic */ Object get(int n2) {
        return this.get(n2);
    }
}

