/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;

public class NBTReadLimiter {
    public static final NBTReadLimiter UNLIMITED = new NBTReadLimiter(0L){

        @Override
        public void accountBytes(long var0) {
        }
    };
    private final long quota;
    private long usage;

    public NBTReadLimiter(long var0) {
        this.quota = var0;
    }

    public void accountBytes(long var0) {
        this.usage += var0;
        if (this.usage > this.quota) {
            throw new RuntimeException("Tried to read NBT tag that was too big; tried to allocate: " + this.usage + "bytes where max allowed: " + this.quota);
        }
    }

    @VisibleForTesting
    public long getUsage() {
        return this.usage;
    }
}

