/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.UtilColor;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(var0 -> var0.getInt(1)).thenComparingInt(var0 -> var0.getInt(0)).thenComparingInt(var0 -> var0.getInt(2));
    private static final Comparator<NBTTagList> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(var0 -> var0.getDouble(1)).thenComparingDouble(var0 -> var0.getDouble(0)).thenComparingDouble(var0 -> var0.getDouble(2));
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private GameProfileSerializer() {
    }

    @Nullable
    public static GameProfile readGameProfile(NBTTagCompound var0) {
        String var1 = null;
        UUID var2 = null;
        if (var0.contains("Name", 8)) {
            var1 = var0.getString("Name");
        }
        if (var0.hasUUID("Id")) {
            var2 = var0.getUUID("Id");
        }
        try {
            GameProfile var3 = new GameProfile(var2, var1);
            if (var0.contains("Properties", 10)) {
                NBTTagCompound var4 = var0.getCompound("Properties");
                for (String var6 : var4.getAllKeys()) {
                    NBTTagList var7 = var4.getList(var6, 10);
                    for (int var8 = 0; var8 < var7.size(); ++var8) {
                        NBTTagCompound var9 = var7.getCompound(var8);
                        String var10 = var9.getString("Value");
                        if (var9.contains("Signature", 8)) {
                            var3.getProperties().put((Object)var6, (Object)new Property(var6, var10, var9.getString("Signature")));
                            continue;
                        }
                        var3.getProperties().put((Object)var6, (Object)new Property(var6, var10));
                    }
                }
            }
            return var3;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static NBTTagCompound writeGameProfile(NBTTagCompound var0, GameProfile var1) {
        if (!UtilColor.isNullOrEmpty(var1.getName())) {
            var0.putString("Name", var1.getName());
        }
        if (var1.getId() != null) {
            var0.putUUID("Id", var1.getId());
        }
        if (!var1.getProperties().isEmpty()) {
            NBTTagCompound var2 = new NBTTagCompound();
            for (String var4 : var1.getProperties().keySet()) {
                NBTTagList var5 = new NBTTagList();
                for (Property var7 : var1.getProperties().get((Object)var4)) {
                    NBTTagCompound var8 = new NBTTagCompound();
                    var8.putString("Value", var7.getValue());
                    if (var7.hasSignature()) {
                        var8.putString("Signature", var7.getSignature());
                    }
                    var5.add(var8);
                }
                var2.put(var4, var5);
            }
            var0.put("Properties", var2);
        }
        return var0;
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable NBTBase var0, @Nullable NBTBase var1, boolean var2) {
        if (var0 == var1) {
            return true;
        }
        if (var0 == null) {
            return true;
        }
        if (var1 == null) {
            return false;
        }
        if (!var0.getClass().equals(var1.getClass())) {
            return false;
        }
        if (var0 instanceof NBTTagCompound) {
            NBTTagCompound var3 = (NBTTagCompound)var0;
            NBTTagCompound var4 = (NBTTagCompound)var1;
            for (String var6 : var3.getAllKeys()) {
                NBTBase var7 = var3.get(var6);
                if (GameProfileSerializer.compareNbt(var7, var4.get(var6), var2)) continue;
                return false;
            }
            return true;
        }
        if (var0 instanceof NBTTagList && var2) {
            NBTTagList var3 = (NBTTagList)var0;
            NBTTagList var4 = (NBTTagList)var1;
            if (var3.isEmpty()) {
                return var4.isEmpty();
            }
            for (int var5 = 0; var5 < var3.size(); ++var5) {
                NBTBase var6 = var3.get(var5);
                boolean var7 = false;
                for (int var8 = 0; var8 < var4.size(); ++var8) {
                    if (!GameProfileSerializer.compareNbt(var6, var4.get(var8), var2)) continue;
                    var7 = true;
                    break;
                }
                if (var7) continue;
                return false;
            }
            return true;
        }
        return var0.equals(var1);
    }

    public static NBTTagIntArray createUUID(UUID var0) {
        return new NBTTagIntArray(UUIDUtil.uuidToIntArray(var0));
    }

    public static UUID loadUUID(NBTBase var0) {
        if (var0.getType() != NBTTagIntArray.TYPE) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + NBTTagIntArray.TYPE.getName() + ", but found " + var0.getType().getName() + ".");
        }
        int[] var1 = ((NBTTagIntArray)var0).getAsIntArray();
        if (var1.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + var1.length + ".");
        }
        return UUIDUtil.uuidFromIntArray(var1);
    }

    public static BlockPosition readBlockPos(NBTTagCompound var0) {
        return new BlockPosition(var0.getInt("X"), var0.getInt("Y"), var0.getInt("Z"));
    }

    public static NBTTagCompound writeBlockPos(BlockPosition var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putInt("X", var0.getX());
        var1.putInt("Y", var0.getY());
        var1.putInt("Z", var0.getZ());
        return var1;
    }

    public static IBlockData readBlockState(HolderGetter<Block> var0, NBTTagCompound var1) {
        if (!var1.contains("Name", 8)) {
            return Blocks.AIR.defaultBlockState();
        }
        MinecraftKey var2 = new MinecraftKey(var1.getString("Name"));
        Optional<Holder.c<Block>> var3 = var0.get(ResourceKey.create(Registries.BLOCK, var2));
        if (var3.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        Block var4 = (Block)((Holder)var3.get()).value();
        IBlockData var5 = var4.defaultBlockState();
        if (var1.contains("Properties", 10)) {
            NBTTagCompound var6 = var1.getCompound("Properties");
            BlockStateList<Block, IBlockData> var7 = var4.getStateDefinition();
            for (String var9 : var6.getAllKeys()) {
                IBlockState<?> var10 = var7.getProperty(var9);
                if (var10 == null) continue;
                var5 = GameProfileSerializer.setValueHelper(var5, var10, var9, var6, var1);
            }
        }
        return var5;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S setValueHelper(S var0, IBlockState<T> var1, String var2, NBTTagCompound var3, NBTTagCompound var4) {
        Optional<T> var5 = var1.getValue(var3.getString(var2));
        if (var5.isPresent()) {
            return (S)((IBlockDataHolder)var0.setValue(var1, (Comparable)((Comparable)var5.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{var2, var3.getString(var2), var4.toString()});
        return var0;
    }

    public static NBTTagCompound writeBlockState(IBlockData var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putString("Name", BuiltInRegistries.BLOCK.getKey(var0.getBlock()).toString());
        ImmutableMap<IBlockState<?>, Comparable<?>> var2 = var0.getValues();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry var5 : var2.entrySet()) {
                IBlockState var6 = (IBlockState)var5.getKey();
                var3.putString(var6.getName(), GameProfileSerializer.getName(var6, (Comparable)var5.getValue()));
            }
            var1.put("Properties", var3);
        }
        return var1;
    }

    public static NBTTagCompound writeFluidState(Fluid var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        var1.putString("Name", BuiltInRegistries.FLUID.getKey(var0.getType()).toString());
        ImmutableMap<IBlockState<?>, Comparable<?>> var2 = var0.getValues();
        if (!var2.isEmpty()) {
            NBTTagCompound var3 = new NBTTagCompound();
            for (Map.Entry var5 : var2.entrySet()) {
                IBlockState var6 = (IBlockState)var5.getKey();
                var3.putString(var6.getName(), GameProfileSerializer.getName(var6, (Comparable)var5.getValue()));
            }
            var1.put("Properties", var3);
        }
        return var1;
    }

    private static <T extends Comparable<T>> String getName(IBlockState<T> var0, Comparable<?> var1) {
        return var0.getName(var1);
    }

    public static String prettyPrint(NBTBase var0) {
        return GameProfileSerializer.prettyPrint(var0, false);
    }

    public static String prettyPrint(NBTBase var0, boolean var1) {
        return GameProfileSerializer.prettyPrint(new StringBuilder(), var0, 0, var1).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder var0, NBTBase var1, int var2, boolean var3) {
        switch (var1.getId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                var0.append(var1);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                NBTTagByteArray var4 = (NBTTagByteArray)var1;
                byte[] var5 = var4.getAsByteArray();
                int var6 = var5.length;
                GameProfileSerializer.indent(var2, var0).append("byte[").append(var6).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (int var7 = 0; var7 < var5.length; ++var7) {
                        if (var7 != 0) {
                            var0.append(',');
                        }
                        if (var7 % 16 == 0 && var7 / 16 > 0) {
                            var0.append('\n');
                            if (var7 < var5.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var7 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%02X", var5[var7] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                break;
            }
            case 9: {
                NBTTagList var4 = (NBTTagList)var1;
                int var5 = var4.size();
                byte var6 = var4.getElementType();
                String var7 = var6 == 0 ? "undefined" : NBTTagTypes.getType(var6).getPrettyName();
                GameProfileSerializer.indent(var2, var0).append("list<").append(var7).append(">[").append(var5).append("] [");
                if (var5 != 0) {
                    var0.append('\n');
                }
                for (int var8 = 0; var8 < var5; ++var8) {
                    if (var8 != 0) {
                        var0.append(",\n");
                    }
                    GameProfileSerializer.indent(var2 + 1, var0);
                    GameProfileSerializer.prettyPrint(var0, var4.get(var8), var2 + 1, var3);
                }
                if (var5 != 0) {
                    var0.append('\n');
                }
                GameProfileSerializer.indent(var2, var0).append(']');
                break;
            }
            case 11: {
                NBTTagIntArray var4 = (NBTTagIntArray)var1;
                int[] var5 = var4.getAsIntArray();
                int var6 = 0;
                int[] var7 = var5;
                int var8 = var7.length;
                for (int i2 = 0; i2 < var8; ++i2) {
                    int var10 = var7[i2];
                    var6 = Math.max(var6, String.format(Locale.ROOT, "%X", var10).length());
                }
                int var12 = var5.length;
                GameProfileSerializer.indent(var2, var0).append("int[").append(var12).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (var8 = 0; var8 < var5.length; ++var8) {
                        if (var8 != 0) {
                            var0.append(',');
                        }
                        if (var8 % 16 == 0 && var8 / 16 > 0) {
                            var0.append('\n');
                            if (var8 < var5.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var8 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var6 + "X", var5[var8]));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                break;
            }
            case 10: {
                NBTTagCompound var4 = (NBTTagCompound)var1;
                ArrayList var5 = Lists.newArrayList(var4.getAllKeys());
                Collections.sort(var5);
                GameProfileSerializer.indent(var2, var0).append('{');
                if (var0.length() - var0.lastIndexOf("\n") > 2 * (var2 + 1)) {
                    var0.append('\n');
                    GameProfileSerializer.indent(var2 + 1, var0);
                }
                int var6 = var5.stream().mapToInt(String::length).max().orElse(0);
                String var13 = Strings.repeat((String)" ", (int)var6);
                for (int var8 = 0; var8 < var5.size(); ++var8) {
                    if (var8 != 0) {
                        var0.append(",\n");
                    }
                    String var9 = (String)var5.get(var8);
                    GameProfileSerializer.indent(var2 + 1, var0).append('\"').append(var9).append('\"').append(var13, 0, var13.length() - var9.length()).append(": ");
                    GameProfileSerializer.prettyPrint(var0, var4.get(var9), var2 + 1, var3);
                }
                if (!var5.isEmpty()) {
                    var0.append('\n');
                }
                GameProfileSerializer.indent(var2, var0).append('}');
                break;
            }
            case 12: {
                int var10;
                NBTTagLongArray var4 = (NBTTagLongArray)var1;
                long[] var5 = var4.getAsLongArray();
                long var6 = 0L;
                long[] var8 = var5;
                int n2 = var8.length;
                for (var10 = 0; var10 < n2; ++var10) {
                    long var11 = var8[var10];
                    var6 = Math.max(var6, (long)String.format(Locale.ROOT, "%X", var11).length());
                }
                long var14 = var5.length;
                GameProfileSerializer.indent(var2, var0).append("long[").append(var14).append("] {\n");
                if (var3) {
                    GameProfileSerializer.indent(var2 + 1, var0);
                    for (var10 = 0; var10 < var5.length; ++var10) {
                        if (var10 != 0) {
                            var0.append(',');
                        }
                        if (var10 % 16 == 0 && var10 / 16 > 0) {
                            var0.append('\n');
                            if (var10 < var5.length) {
                                GameProfileSerializer.indent(var2 + 1, var0);
                            }
                        } else if (var10 != 0) {
                            var0.append(' ');
                        }
                        var0.append(String.format(Locale.ROOT, "0x%0" + var6 + "X", var5[var10]));
                    }
                } else {
                    GameProfileSerializer.indent(var2 + 1, var0).append(" // Skipped, supply withBinaryBlobs true");
                }
                var0.append('\n');
                GameProfileSerializer.indent(var2, var0).append('}');
                break;
            }
            default: {
                var0.append("<UNKNOWN :(>");
            }
        }
        return var0;
    }

    private static StringBuilder indent(int var0, StringBuilder var1) {
        int var2 = var1.lastIndexOf("\n") + 1;
        int var3 = var1.length() - var2;
        for (int var4 = 0; var4 < 2 * var0 - var3; ++var4) {
            var1.append(' ');
        }
        return var1;
    }

    public static NBTTagCompound update(DataFixer var0, DataFixTypes var1, NBTTagCompound var2, int var3) {
        return GameProfileSerializer.update(var0, var1, var2, var3, SharedConstants.getCurrentVersion().getWorldVersion());
    }

    public static NBTTagCompound update(DataFixer var0, DataFixTypes var1, NBTTagCompound var2, int var3, int var4) {
        return (NBTTagCompound)var0.update(var1.getType(), new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var2), var3, var4).getValue();
    }

    public static IChatBaseComponent toPrettyComponent(NBTBase var0) {
        return new TextComponentTagVisitor("", 0).visit(var0);
    }

    public static String structureToSnbt(NBTTagCompound var0) {
        return new SnbtPrinterTagVisitor().visit(GameProfileSerializer.packStructureTemplate(var0));
    }

    public static NBTTagCompound snbtToStructure(String var0) throws CommandSyntaxException {
        return GameProfileSerializer.unpackStructureTemplate(MojangsonParser.parseTag(var0));
    }

    @VisibleForTesting
    static NBTTagCompound packStructureTemplate(NBTTagCompound var02) {
        NBTTagList var5;
        NBTTagList var4;
        boolean var22 = var02.contains("palettes", 9);
        NBTTagList var12 = var22 ? var02.getList("palettes", 9).getList(0) : var02.getList("palette", 10);
        NBTTagList var3 = var12.stream().map(NBTTagCompound.class::cast).map(GameProfileSerializer::packBlockState).map(NBTTagString::valueOf).collect(Collectors.toCollection(NBTTagList::new));
        var02.put("palette", var3);
        if (var22) {
            var4 = new NBTTagList();
            var5 = var02.getList("palettes", 9);
            var5.stream().map(NBTTagList.class::cast).forEach(var2 -> {
                NBTTagCompound var3 = new NBTTagCompound();
                for (int var4 = 0; var4 < var2.size(); ++var4) {
                    var3.putString(var3.getString(var4), GameProfileSerializer.packBlockState(var2.getCompound(var4)));
                }
                var4.add(var3);
            });
            var02.put("palettes", var4);
        }
        if (var02.contains("entities", 9)) {
            var4 = var02.getList("entities", 10);
            var5 = var4.stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(var0 -> var0.getList("pos", 6), YXZ_LISTTAG_DOUBLE_COMPARATOR)).collect(Collectors.toCollection(NBTTagList::new));
            var02.put("entities", var5);
        }
        var4 = var02.getList("blocks", 10).stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(var0 -> var0.getList("pos", 3), YXZ_LISTTAG_INT_COMPARATOR)).peek(var1 -> var1.putString("state", var3.getString(var1.getInt("state")))).collect(Collectors.toCollection(NBTTagList::new));
        var02.put(SNBT_DATA_TAG, var4);
        var02.remove("blocks");
        return var02;
    }

    @VisibleForTesting
    static NBTTagCompound unpackStructureTemplate(NBTTagCompound var0) {
        NBTTagList var12 = var0.getList("palette", 8);
        Map var2 = (Map)var12.stream().map(NBTTagString.class::cast).map(NBTTagString::getAsString).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::unpackBlockState));
        if (var0.contains("palettes", 9)) {
            var0.put("palettes", var0.getList("palettes", 10).stream().map(NBTTagCompound.class::cast).map(var1 -> var2.keySet().stream().map(var1::getString).map(GameProfileSerializer::unpackBlockState).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            var0.remove("palette");
        } else {
            var0.put("palette", var2.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        if (var0.contains(SNBT_DATA_TAG, 9)) {
            Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
            var3.defaultReturnValue(-1);
            for (int var4 = 0; var4 < var12.size(); ++var4) {
                var3.put((Object)var12.getString(var4), var4);
            }
            NBTTagList var4 = var0.getList(SNBT_DATA_TAG, 10);
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                NBTTagCompound var6 = var4.getCompound(var5);
                String var7 = var6.getString("state");
                int var8 = var3.getInt((Object)var7);
                if (var8 == -1) {
                    throw new IllegalStateException("Entry " + var7 + " missing from palette");
                }
                var6.putInt("state", var8);
            }
            var0.put("blocks", var4);
            var0.remove(SNBT_DATA_TAG);
        }
        return var0;
    }

    @VisibleForTesting
    static String packBlockState(NBTTagCompound var0) {
        StringBuilder var12 = new StringBuilder(var0.getString("Name"));
        if (var0.contains("Properties", 10)) {
            NBTTagCompound var2 = var0.getCompound("Properties");
            String var3 = var2.getAllKeys().stream().sorted().map(var1 -> var1 + ":" + var2.get((String)var1).getAsString()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            var12.append('{').append(var3).append('}');
        }
        return var12.toString();
    }

    @VisibleForTesting
    static NBTTagCompound unpackBlockState(String var0) {
        String var3;
        NBTTagCompound var1 = new NBTTagCompound();
        int var22 = var0.indexOf(123);
        if (var22 >= 0) {
            var3 = var0.substring(0, var22);
            NBTTagCompound var4 = new NBTTagCompound();
            if (var22 + 2 <= var0.length()) {
                String var5 = var0.substring(var22 + 1, var0.indexOf(125, var22));
                COMMA_SPLITTER.split((CharSequence)var5).forEach(var2 -> {
                    List var3 = COLON_SPLITTER.splitToList((CharSequence)var2);
                    if (var3.size() == 2) {
                        var4.putString((String)var3.get(0), (String)var3.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)var0);
                    }
                });
                var1.put("Properties", var4);
            }
        } else {
            var3 = var0;
        }
        var1.putString("Name", var3);
        return var1;
    }
}

