/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class VibrationParticleOption
implements ParticleParam {
    public static final Codec<VibrationParticleOption> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)PositionSource.CODEC.fieldOf("destination").forGetter(var0 -> var0.destination), (App)Codec.INT.fieldOf("arrival_in_ticks").forGetter(var0 -> var0.arrivalInTicks)).apply((Applicative)var02, VibrationParticleOption::new));
    public static final ParticleParam.a<VibrationParticleOption> DESERIALIZER = new ParticleParam.a<VibrationParticleOption>(){

        @Override
        public VibrationParticleOption fromCommand(Particle<VibrationParticleOption> var0, StringReader var1) throws CommandSyntaxException {
            var1.expect(' ');
            float var2 = (float)var1.readDouble();
            var1.expect(' ');
            float var3 = (float)var1.readDouble();
            var1.expect(' ');
            float var4 = (float)var1.readDouble();
            var1.expect(' ');
            int var5 = var1.readInt();
            BlockPosition var6 = new BlockPosition(var2, var3, var4);
            return new VibrationParticleOption(new BlockPositionSource(var6), var5);
        }

        @Override
        public VibrationParticleOption fromNetwork(Particle<VibrationParticleOption> var0, PacketDataSerializer var1) {
            PositionSource var2 = PositionSourceType.fromNetwork(var1);
            int var3 = var1.readVarInt();
            return new VibrationParticleOption(var2, var3);
        }

        @Override
        public /* synthetic */ ParticleParam fromNetwork(Particle particle, PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(particle, packetDataSerializer);
        }

        @Override
        public /* synthetic */ ParticleParam fromCommand(Particle particle, StringReader stringReader) throws CommandSyntaxException {
            return this.fromCommand(particle, stringReader);
        }
    };
    private final PositionSource destination;
    private final int arrivalInTicks;

    public VibrationParticleOption(PositionSource var0, int var1) {
        this.destination = var0;
        this.arrivalInTicks = var1;
    }

    @Override
    public void writeToNetwork(PacketDataSerializer var0) {
        PositionSourceType.toNetwork(this.destination, var0);
        var0.writeVarInt(this.arrivalInTicks);
    }

    @Override
    public String writeToString() {
        Vec3D var0 = this.destination.getPosition(null).get();
        double var1 = var0.x();
        double var3 = var0.y();
        double var5 = var0.z();
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %d", BuiltInRegistries.PARTICLE_TYPE.getKey(this.getType()), var1, var3, var5, this.arrivalInTicks);
    }

    public Particle<VibrationParticleOption> getType() {
        return Particles.VIBRATION;
    }

    public PositionSource getDestination() {
        return this.destination;
    }

    public int getArrivalInTicks() {
        return this.arrivalInTicks;
    }
}

