/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;

public class RegistrySynchronization {
    private static final Map<ResourceKey<? extends IRegistry<?>>, a<?>> NETWORKABLE_REGISTRIES = (Map)SystemUtils.make(() -> {
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        RegistrySynchronization.put(var0, Registries.BIOME, BiomeBase.NETWORK_CODEC);
        RegistrySynchronization.put(var0, Registries.CHAT_TYPE, ChatMessageType.CODEC);
        RegistrySynchronization.put(var0, Registries.DIMENSION_TYPE, DimensionManager.DIRECT_CODEC);
        return var0.build();
    });
    public static final Codec<IRegistryCustom> NETWORK_CODEC = RegistrySynchronization.makeNetworkCodec();

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, a<?>> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2) {
        var0.put(var1, new a<E>(var1, var2));
    }

    private static Stream<IRegistryCustom.d<?>> ownedNetworkableRegistries(IRegistryCustom var02) {
        return var02.registries().filter(var0 -> NETWORKABLE_REGISTRIES.containsKey(var0.key()));
    }

    private static <E> DataResult<? extends Codec<E>> getNetworkCodec(ResourceKey<? extends IRegistry<E>> var02) {
        return Optional.ofNullable(NETWORKABLE_REGISTRIES.get(var02)).map(var0 -> var0.networkCodec()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + var02)));
    }

    private static <E> Codec<IRegistryCustom> makeNetworkCodec() {
        Codec var02 = MinecraftKey.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
        Codec var1 = var02.partialDispatch("type", var0 -> DataResult.success(var0.key()), var0 -> RegistrySynchronization.getNetworkCodec(var0).map(var1 -> RegistryCodecs.networkCodec(var0, Lifecycle.experimental(), var1)));
        UnboundedMapCodec var2 = Codec.unboundedMap((Codec)var02, (Codec)var1);
        return RegistrySynchronization.captureMap(var2);
    }

    private static <K extends ResourceKey<? extends IRegistry<?>>, V extends IRegistry<?>> Codec<IRegistryCustom> captureMap(UnboundedMapCodec<K, V> var0) {
        return var0.xmap(IRegistryCustom.c::new, var02 -> (Map)RegistrySynchronization.ownedNetworkableRegistries(var02).collect(ImmutableMap.toImmutableMap(var0 -> var0.key(), var0 -> var0.value())));
    }

    public static Stream<IRegistryCustom.d<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        return RegistrySynchronization.ownedNetworkableRegistries(var0.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<IRegistryCustom.d<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        Stream<IRegistryCustom.d<?>> var1 = var0.getLayer(RegistryLayer.STATIC).registries();
        Stream<IRegistryCustom.d<?>> var2 = RegistrySynchronization.networkedRegistries(var0);
        return Stream.concat(var2, var1);
    }

    record a<E>(ResourceKey<? extends IRegistry<E>> key, Codec<E> networkCodec) {
    }
}

