/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;

public class RegistryCodecs {
    private static <T> MapCodec<a<T>> withNameAndId(ResourceKey<? extends IRegistry<T>> var0, MapCodec<T> var1) {
        return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)ResourceKey.codec(var0).fieldOf("name").forGetter(a::key), (App)Codec.INT.fieldOf("id").forGetter(a::id), (App)var1.forGetter(a::value)).apply((Applicative)var2, a::new));
    }

    public static <T> Codec<IRegistry<T>> networkCodec(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, Codec<T> var22) {
        return RegistryCodecs.withNameAndId(var02, var22.fieldOf("element")).codec().listOf().xmap(var2 -> {
            RegistryMaterials var3 = new RegistryMaterials(var02, var1);
            for (a var5 : var2) {
                var3.registerMapping(var5.id(), var5.key(), var5.value(), var1);
            }
            return var3;
        }, var0 -> {
            ImmutableList.Builder var1 = ImmutableList.builder();
            for (Object var3 : var0) {
                var1.add(new a(var0.getResourceKey(var3).get(), var0.getId(var3), var3));
            }
            return var1.build();
        });
    }

    public static <E> Codec<IRegistry<E>> fullCodec(ResourceKey<? extends IRegistry<E>> var02, Lifecycle var1, Codec<E> var2) {
        UnboundedMapCodec var3 = Codec.unboundedMap(ResourceKey.codec(var02), var2);
        return var3.xmap(var22 -> {
            RegistryMaterials var32 = new RegistryMaterials(var02, var1);
            var22.forEach((var2, var3) -> var32.register(var2, var3, var1));
            return var32.freeze();
        }, var0 -> ImmutableMap.copyOf(var0.entrySet()));
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1) {
        return RegistryCodecs.homogeneousList(var0, var1, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, Codec<E> var1, boolean var2) {
        return HolderSetCodec.create(var0, RegistryFileCodec.create(var0, var1), var2);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0) {
        return RegistryCodecs.homogeneousList(var0, false);
    }

    public static <E> Codec<HolderSet<E>> homogeneousList(ResourceKey<? extends IRegistry<E>> var0, boolean var1) {
        return HolderSetCodec.create(var0, RegistryFixedCodec.create(var0), var1);
    }

    record a<T>(ResourceKey<T> key, int id, T value) {
    }
}

