/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntitySelector {
    public static final int INFINITE = Integer.MAX_VALUE;
    public static final BiConsumer<Vec3D, List<? extends Entity>> ORDER_ARBITRARY = (var0, var1) -> {};
    private static final EntityTypeTest<Entity, ?> ANY_TYPE = new EntityTypeTest<Entity, Entity>(){

        @Override
        public Entity tryCast(Entity var0) {
            return var0;
        }

        @Override
        public Class<? extends Entity> getBaseClass() {
            return Entity.class;
        }
    };
    private final int maxResults;
    private final boolean includesEntities;
    private final boolean worldLimited;
    private final Predicate<Entity> predicate;
    private final CriterionConditionValue.DoubleRange range;
    private final Function<Vec3D, Vec3D> position;
    @Nullable
    private final AxisAlignedBB aabb;
    private final BiConsumer<Vec3D, List<? extends Entity>> order;
    private final boolean currentEntity;
    @Nullable
    private final String playerName;
    @Nullable
    private final UUID entityUUID;
    private final EntityTypeTest<Entity, ?> type;
    private final boolean usesSelector;

    public EntitySelector(int var0, boolean var1, boolean var2, Predicate<Entity> var3, CriterionConditionValue.DoubleRange var4, Function<Vec3D, Vec3D> var5, @Nullable AxisAlignedBB var6, BiConsumer<Vec3D, List<? extends Entity>> var7, boolean var8, @Nullable String var9, @Nullable UUID var10, @Nullable EntityTypes<?> var11, boolean var12) {
        this.maxResults = var0;
        this.includesEntities = var1;
        this.worldLimited = var2;
        this.predicate = var3;
        this.range = var4;
        this.position = var5;
        this.aabb = var6;
        this.order = var7;
        this.currentEntity = var8;
        this.playerName = var9;
        this.entityUUID = var10;
        this.type = var11 == null ? ANY_TYPE : var11;
        this.usesSelector = var12;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean includesEntities() {
        return this.includesEntities;
    }

    public boolean isSelfSelector() {
        return this.currentEntity;
    }

    public boolean isWorldLimited() {
        return this.worldLimited;
    }

    public boolean usesSelector() {
        return this.usesSelector;
    }

    private void checkPermissions(CommandListenerWrapper var0) throws CommandSyntaxException {
        if (this.usesSelector && !var0.hasPermission(2)) {
            throw ArgumentEntity.ERROR_SELECTORS_NOT_ALLOWED.create();
        }
    }

    public Entity findSingleEntity(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        List<? extends Entity> var1 = this.findEntities(var0);
        if (var1.isEmpty()) {
            throw ArgumentEntity.NO_ENTITIES_FOUND.create();
        }
        if (var1.size() > 1) {
            throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
        }
        return var1.get(0);
    }

    public List<? extends Entity> findEntities(CommandListenerWrapper var0) throws CommandSyntaxException {
        return this.findEntitiesRaw(var0).stream().filter(var1 -> var1.getType().isEnabled(var0.enabledFeatures())).toList();
    }

    private List<? extends Entity> findEntitiesRaw(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        if (!this.includesEntities) {
            return this.findPlayers(var0);
        }
        if (this.playerName != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayerByName(this.playerName);
            if (var1 == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new EntityPlayer[]{var1});
        }
        if (this.entityUUID != null) {
            for (WorldServer var2 : var0.getServer().getAllLevels()) {
                Entity var3 = var2.getEntity(this.entityUUID);
                if (var3 == null) continue;
                return Lists.newArrayList((Object[])new Entity[]{var3});
            }
            return Collections.emptyList();
        }
        Vec3D var1 = this.position.apply(var0.getPosition());
        Predicate<Entity> var2 = this.getPredicate(var1);
        if (this.currentEntity) {
            if (var0.getEntity() != null && var2.test(var0.getEntity())) {
                return Lists.newArrayList((Object[])new Entity[]{var0.getEntity()});
            }
            return Collections.emptyList();
        }
        ArrayList var3 = Lists.newArrayList();
        if (this.isWorldLimited()) {
            this.addEntities(var3, var0.getLevel(), var1, var2);
        } else {
            for (WorldServer var5 : var0.getServer().getAllLevels()) {
                this.addEntities(var3, var5, var1, var2);
            }
        }
        return this.sortAndLimit(var1, var3);
    }

    private void addEntities(List<Entity> var0, WorldServer var1, Vec3D var2, Predicate<Entity> var3) {
        int var4 = this.getResultLimit();
        if (var0.size() >= var4) {
            return;
        }
        if (this.aabb != null) {
            var1.getEntities(this.type, this.aabb.move(var2), var3, var0, var4);
        } else {
            var1.getEntities(this.type, var3, var0, var4);
        }
    }

    private int getResultLimit() {
        return this.order == ORDER_ARBITRARY ? this.maxResults : Integer.MAX_VALUE;
    }

    public EntityPlayer findSinglePlayer(CommandListenerWrapper var0) throws CommandSyntaxException {
        this.checkPermissions(var0);
        List<EntityPlayer> var1 = this.findPlayers(var0);
        if (var1.size() != 1) {
            throw ArgumentEntity.NO_PLAYERS_FOUND.create();
        }
        return var1.get(0);
    }

    public List<EntityPlayer> findPlayers(CommandListenerWrapper var0) throws CommandSyntaxException {
        List<Object> var3;
        this.checkPermissions(var0);
        if (this.playerName != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayerByName(this.playerName);
            if (var1 == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new EntityPlayer[]{var1});
        }
        if (this.entityUUID != null) {
            EntityPlayer var1 = var0.getServer().getPlayerList().getPlayer(this.entityUUID);
            if (var1 == null) {
                return Collections.emptyList();
            }
            return Lists.newArrayList((Object[])new EntityPlayer[]{var1});
        }
        Vec3D var1 = this.position.apply(var0.getPosition());
        Predicate<Entity> var2 = this.getPredicate(var1);
        if (this.currentEntity) {
            EntityPlayer var32;
            if (var0.getEntity() instanceof EntityPlayer && var2.test(var32 = (EntityPlayer)var0.getEntity())) {
                return Lists.newArrayList((Object[])new EntityPlayer[]{var32});
            }
            return Collections.emptyList();
        }
        int var4 = this.getResultLimit();
        if (this.isWorldLimited()) {
            var3 = var0.getLevel().getPlayers(var2, var4);
        } else {
            var3 = Lists.newArrayList();
            for (EntityPlayer var6 : var0.getServer().getPlayerList().getPlayers()) {
                if (!var2.test(var6)) continue;
                var3.add(var6);
                if (var3.size() < var4) continue;
                return var3;
            }
        }
        return this.sortAndLimit(var1, var3);
    }

    private Predicate<Entity> getPredicate(Vec3D var0) {
        Predicate<Entity> var12 = this.predicate;
        if (this.aabb != null) {
            AxisAlignedBB var2 = this.aabb.move(var0);
            var12 = var12.and(var1 -> var2.intersects(var1.getBoundingBox()));
        }
        if (!this.range.isAny()) {
            var12 = var12.and(var1 -> this.range.matchesSqr(var1.distanceToSqr(var0)));
        }
        return var12;
    }

    private <T extends Entity> List<T> sortAndLimit(Vec3D var0, List<T> var1) {
        if (var1.size() > 1) {
            this.order.accept(var0, var1);
        }
        return var1.subList(0, Math.min(this.maxResults, var1.size()));
    }

    public static IChatBaseComponent joinNames(List<? extends Entity> var0) {
        return ChatComponentUtils.formatList(var0, Entity::getDisplayName);
    }
}

