/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.INamable;

public class StringRepresentableArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.enum.invalid", var0));
    private final Codec<T> codec;
    private final Supplier<T[]> values;

    protected StringRepresentableArgument(Codec<T> var0, Supplier<T[]> var1) {
        this.codec = var0;
        this.values = var1;
    }

    public T parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        return (T)((Enum)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(var1)).result().orElseThrow(() -> ERROR_INVALID_VALUE.create((Object)var1)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var02, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(Arrays.stream((Enum[])this.values.get()).map(var0 -> ((INamable)var0).getSerializedName()).collect(Collectors.toList()), var1);
    }

    public Collection<String> getExamples() {
        return Arrays.stream((Enum[])this.values.get()).map(var0 -> ((INamable)var0).getSerializedName()).limit(2L).collect(Collectors.toList());
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

