/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentTime
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType ERROR_INVALID_UNIT = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.time.invalid_unit"));
    private static final DynamicCommandExceptionType ERROR_INVALID_TICK_COUNT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("argument.time.invalid_tick_count", var0));
    private static final Object2IntMap<String> UNITS = new Object2IntOpenHashMap();

    public static ArgumentTime time() {
        return new ArgumentTime();
    }

    public Integer parse(StringReader var0) throws CommandSyntaxException {
        float var1 = var0.readFloat();
        String var2 = var0.readUnquotedString();
        int var3 = UNITS.getOrDefault((Object)var2, 0);
        if (var3 == 0) {
            throw ERROR_INVALID_UNIT.create();
        }
        int var4 = Math.round(var1 * (float)var3);
        if (var4 < 0) {
            throw ERROR_INVALID_TICK_COUNT.create((Object)var4);
        }
        return var4;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        StringReader var2 = new StringReader(var1.getRemaining());
        try {
            var2.readFloat();
        }
        catch (CommandSyntaxException var3) {
            return var1.buildFuture();
        }
        return ICompletionProvider.suggest((Iterable<String>)UNITS.keySet(), var1.createOffset(var1.getStart() + var2.getCursor()));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static {
        UNITS.put((Object)"d", 24000);
        UNITS.put((Object)"s", 20);
        UNITS.put((Object)"t", 1);
        UNITS.put((Object)"", 1);
    }
}

