/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class CommandDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher = new com.mojang.brigadier.CommandDispatcher();

    public CommandDispatcher(ServerType var02, CommandBuildContext var12) {
        CommandAdvancement.register(this.dispatcher);
        CommandAttribute.register(this.dispatcher, var12);
        CommandExecute.register(this.dispatcher, var12);
        CommandBossBar.register(this.dispatcher);
        CommandClear.register(this.dispatcher, var12);
        CommandClone.register(this.dispatcher, var12);
        CommandData.register(this.dispatcher);
        CommandDatapack.register(this.dispatcher);
        CommandDebug.register(this.dispatcher);
        CommandGamemodeDefault.register(this.dispatcher);
        CommandDifficulty.register(this.dispatcher);
        CommandEffect.register(this.dispatcher, var12);
        CommandMe.register(this.dispatcher);
        CommandEnchant.register(this.dispatcher, var12);
        CommandXp.register(this.dispatcher);
        CommandFill.register(this.dispatcher, var12);
        FillBiomeCommand.register(this.dispatcher, var12);
        CommandForceload.register(this.dispatcher);
        CommandFunction.register(this.dispatcher);
        CommandGamemode.register(this.dispatcher);
        CommandGamerule.register(this.dispatcher);
        CommandGive.register(this.dispatcher, var12);
        CommandHelp.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, var12);
        CommandKick.register(this.dispatcher);
        CommandKill.register(this.dispatcher);
        CommandList.register(this.dispatcher);
        CommandLocate.register(this.dispatcher, var12);
        CommandLoot.register(this.dispatcher, var12);
        CommandTell.register(this.dispatcher);
        CommandParticle.register(this.dispatcher, var12);
        PlaceCommand.register(this.dispatcher);
        CommandPlaySound.register(this.dispatcher);
        CommandReload.register(this.dispatcher);
        CommandRecipe.register(this.dispatcher);
        CommandSay.register(this.dispatcher);
        CommandSchedule.register(this.dispatcher);
        CommandScoreboard.register(this.dispatcher);
        CommandSeed.register(this.dispatcher, var02 != ServerType.INTEGRATED);
        CommandSetBlock.register(this.dispatcher, var12);
        CommandSpawnpoint.register(this.dispatcher);
        CommandSetWorldSpawn.register(this.dispatcher);
        CommandSpectate.register(this.dispatcher);
        CommandSpreadPlayers.register(this.dispatcher);
        CommandStopSound.register(this.dispatcher);
        CommandSummon.register(this.dispatcher, var12);
        CommandTag.register(this.dispatcher);
        CommandTeam.register(this.dispatcher);
        CommandTeamMsg.register(this.dispatcher);
        CommandTeleport.register(this.dispatcher);
        CommandTellRaw.register(this.dispatcher);
        CommandTime.register(this.dispatcher);
        CommandTitle.register(this.dispatcher);
        CommandTrigger.register(this.dispatcher);
        CommandWeather.register(this.dispatcher);
        CommandWorldBorder.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            GameTestHarnessTestCommand.register(this.dispatcher);
        }
        if (var02.includeDedicated) {
            CommandBanIp.register(this.dispatcher);
            CommandBanList.register(this.dispatcher);
            CommandBan.register(this.dispatcher);
            CommandDeop.register(this.dispatcher);
            CommandOp.register(this.dispatcher);
            CommandPardon.register(this.dispatcher);
            CommandPardonIP.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            CommandSaveAll.register(this.dispatcher);
            CommandSaveOff.register(this.dispatcher);
            CommandSaveOn.register(this.dispatcher);
            CommandIdleTimeout.register(this.dispatcher);
            CommandStop.register(this.dispatcher);
            CommandWhitelist.register(this.dispatcher);
        }
        if (var02.includeIntegrated) {
            CommandPublish.register(this.dispatcher);
        }
        this.dispatcher.setConsumer((var0, var1, var2) -> ((CommandListenerWrapper)var0.getSource()).onCommandComplete((CommandContext<CommandListenerWrapper>)var0, var1, var2));
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> var0, UnaryOperator<S> var1) {
        CommandContextBuilder var2 = var0.getContext();
        CommandContextBuilder var3 = var2.withSource(var1.apply(var2.getSource()));
        return new ParseResults(var3, var0.getReader(), var0.getExceptions());
    }

    public int performPrefixedCommand(CommandListenerWrapper var0, String var1) {
        var1 = var1.startsWith("/") ? var1.substring(1) : var1;
        return this.performCommand((ParseResults<CommandListenerWrapper>)this.dispatcher.parse(var1, (Object)var0), var1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performCommand(ParseResults<CommandListenerWrapper> var0, String var12) {
        CommandListenerWrapper var2 = (CommandListenerWrapper)var0.getContext().getSource();
        var2.getServer().getProfiler().push(() -> "/" + var12);
        try {
            int n2 = this.dispatcher.execute(var0);
            return n2;
        }
        catch (CommandException var3) {
            var2.sendFailure(var3.getComponent());
            int n3 = 0;
            return n3;
        }
        catch (CommandSyntaxException var3) {
            int var4;
            var2.sendFailure(ChatComponentUtils.fromMessage(var3.getRawMessage()));
            if (var3.getInput() != null && var3.getCursor() >= 0) {
                var4 = Math.min(var3.getInput().length(), var3.getCursor());
                IChatMutableComponent var5 = IChatBaseComponent.empty().withStyle(EnumChatFormat.GRAY).withStyle(var1 -> var1.withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/" + var12)));
                if (var4 > 10) {
                    var5.append(CommonComponents.ELLIPSIS);
                }
                var5.append(var3.getInput().substring(Math.max(0, var4 - 10), var4));
                if (var4 < var3.getInput().length()) {
                    IChatMutableComponent var6 = IChatBaseComponent.literal(var3.getInput().substring(var4)).withStyle(EnumChatFormat.RED, EnumChatFormat.UNDERLINE);
                    var5.append(var6);
                }
                var5.append(IChatBaseComponent.translatable("command.context.here").withStyle(EnumChatFormat.RED, EnumChatFormat.ITALIC));
                var2.sendFailure(var5);
            }
            var4 = 0;
            return var4;
        }
        catch (Exception var3) {
            IChatMutableComponent var4 = IChatBaseComponent.literal(var3.getMessage() == null ? var3.getClass().getName() : var3.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Command exception: /{}", (Object)var12, (Object)var3);
                StackTraceElement[] var5 = var3.getStackTrace();
                for (int var6 = 0; var6 < Math.min(var5.length, 3); ++var6) {
                    var4.append("\n\n").append(var5[var6].getMethodName()).append("\n ").append(var5[var6].getFileName()).append(":").append(String.valueOf(var5[var6].getLineNumber()));
                }
            }
            var2.sendFailure(IChatBaseComponent.translatable("command.failed").withStyle(var1 -> var1.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, var4))));
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                var2.sendFailure(IChatBaseComponent.literal(SystemUtils.describeError(var3)));
                LOGGER.error("'/{}' threw an exception", (Object)var12, (Object)var3);
            }
            int n4 = 0;
            return n4;
        }
        finally {
            var2.getServer().getProfiler().pop();
        }
    }

    public void sendCommands(EntityPlayer var0) {
        HashMap var1 = Maps.newHashMap();
        RootCommandNode var2 = new RootCommandNode();
        var1.put(this.dispatcher.getRoot(), var2);
        this.fillUsableCommands((CommandNode<CommandListenerWrapper>)this.dispatcher.getRoot(), (CommandNode<ICompletionProvider>)var2, var0.createCommandSourceStack(), var1);
        var0.connection.send(new PacketPlayOutCommands((RootCommandNode<ICompletionProvider>)var2));
    }

    private void fillUsableCommands(CommandNode<CommandListenerWrapper> var02, CommandNode<ICompletionProvider> var1, CommandListenerWrapper var2, Map<CommandNode<CommandListenerWrapper>, CommandNode<ICompletionProvider>> var3) {
        for (CommandNode var5 : var02.getChildren()) {
            RequiredArgumentBuilder var7;
            if (!var5.canUse((Object)var2)) continue;
            ArgumentBuilder var6 = var5.createBuilder();
            var6.requires(var0 -> true);
            if (var6.getCommand() != null) {
                var6.executes(var0 -> 0);
            }
            if (var6 instanceof RequiredArgumentBuilder && (var7 = (RequiredArgumentBuilder)var6).getSuggestionsProvider() != null) {
                var7.suggests(CompletionProviders.safelySwap((SuggestionProvider<ICompletionProvider>)var7.getSuggestionsProvider()));
            }
            if (var6.getRedirect() != null) {
                var6.redirect(var3.get(var6.getRedirect()));
            }
            var7 = var6.build();
            var3.put((CommandNode<CommandListenerWrapper>)var5, (CommandNode<ICompletionProvider>)var7);
            var1.addChild((CommandNode)var7);
            if (var5.getChildren().isEmpty()) continue;
            this.fillUsableCommands((CommandNode<CommandListenerWrapper>)var5, (CommandNode<ICompletionProvider>)var7, var2, var3);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> literal(String var0) {
        return LiteralArgumentBuilder.literal((String)var0);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> argument(String var0, ArgumentType<T> var1) {
        return RequiredArgumentBuilder.argument((String)var0, var1);
    }

    public static Predicate<String> createValidator(b var0) {
        return var1 -> {
            try {
                var0.parse(new StringReader(var1));
                return true;
            }
            catch (CommandSyntaxException var2) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> var0) {
        if (!var0.getReader().canRead()) {
            return null;
        }
        if (var0.getExceptions().size() == 1) {
            return (CommandSyntaxException)((Object)var0.getExceptions().values().iterator().next());
        }
        if (var0.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(var0.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(var0.getReader());
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.b var0) {
        return new CommandBuildContext(){

            @Override
            public <T> HolderLookup<T> holderLookup(ResourceKey<? extends IRegistry<T>> var02) {
                final HolderLookup.c var1 = var0.lookupOrThrow(var02);
                return new HolderLookup.a<T>(var1){

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                        return Optional.of(this.getOrThrow(var0));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
                        Optional<HolderSet.Named<HolderSet.Named>> var12 = var1.get(var0);
                        return var12.orElseGet(() -> HolderSet.emptyNamed(var1, var0));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext var02 = CommandDispatcher.createValidationContext(VanillaRegistries.createLookup());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var12 = new CommandDispatcher(ServerType.ALL, var02).getDispatcher();
        RootCommandNode var22 = var12.getRoot();
        var12.findAmbiguities((var1, var2, var3, var4) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{var12.getPath(var2), var12.getPath(var3), var4}));
        Set<ArgumentType<?>> var32 = ArgumentUtils.findUsedArgumentTypes(var22);
        Set var42 = var32.stream().filter(var0 -> !ArgumentTypeInfos.isClassRecognized(var0.getClass())).collect(Collectors.toSet());
        if (!var42.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)var42.stream().map(var0 -> "\t" + var0).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static final class ServerType
    extends Enum<ServerType> {
        public static final /* enum */ ServerType ALL = new ServerType(true, true);
        public static final /* enum */ ServerType DEDICATED = new ServerType(false, true);
        public static final /* enum */ ServerType INTEGRATED = new ServerType(true, false);
        final boolean includeIntegrated;
        final boolean includeDedicated;
        private static final /* synthetic */ ServerType[] f;

        public static ServerType[] values() {
            return (ServerType[])f.clone();
        }

        public static ServerType valueOf(String var0) {
            return Enum.valueOf(ServerType.class, var0);
        }

        private ServerType(boolean var2, boolean var3) {
            this.includeIntegrated = var2;
            this.includeDedicated = var3;
        }

        private static /* synthetic */ ServerType[] a() {
            return new ServerType[]{ALL, DEDICATED, INTEGRATED};
        }

        static {
            f = ServerType.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

