/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionLocation;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionTriggerPlacedBlock
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("placed_block");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, CriterionConditionEntity.b var12, LootDeserializationContext var2) {
        Block var3 = CriterionTriggerPlacedBlock.deserializeBlock(var0);
        CriterionTriggerProperties var4 = CriterionTriggerProperties.fromJson(var0.get("state"));
        if (var3 != null) {
            var4.checkState(var3.getStateDefinition(), var1 -> {
                throw new JsonSyntaxException("Block " + var3 + " has no property " + var1 + ":");
            });
        }
        CriterionConditionLocation var5 = CriterionConditionLocation.fromJson(var0.get("location"));
        CriterionConditionItem var6 = CriterionConditionItem.fromJson(var0.get("item"));
        return new a(var12, var3, var4, var5, var6);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject var0) {
        if (var0.has("block")) {
            MinecraftKey var1 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            return (Block)BuiltInRegistries.BLOCK.getOptional(var1).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + var1 + "'"));
        }
        return null;
    }

    public void trigger(EntityPlayer var0, BlockPosition var1, ItemStack var2) {
        IBlockData var3 = var0.getLevel().getBlockState(var1);
        this.trigger(var0, var4 -> var4.matches(var3, var1, var0.getLevel(), var2));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, CriterionConditionEntity.b b2, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, b2, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        @Nullable
        private final Block block;
        private final CriterionTriggerProperties state;
        private final CriterionConditionLocation location;
        private final CriterionConditionItem item;

        public a(CriterionConditionEntity.b var0, @Nullable Block var1, CriterionTriggerProperties var2, CriterionConditionLocation var3, CriterionConditionItem var4) {
            super(ID, var0);
            this.block = var1;
            this.state = var2;
            this.location = var3;
            this.item = var4;
        }

        public static a placedBlock(Block var0) {
            return new a(CriterionConditionEntity.b.ANY, var0, CriterionTriggerProperties.ANY, CriterionConditionLocation.ANY, CriterionConditionItem.ANY);
        }

        public boolean matches(IBlockData var0, BlockPosition var1, WorldServer var2, ItemStack var3) {
            if (this.block != null && !var0.is(this.block)) {
                return false;
            }
            if (!this.state.matches(var0)) {
                return false;
            }
            if (!this.location.matches(var2, var1.getX(), var1.getY(), var1.getZ())) {
                return false;
            }
            return this.item.matches(var3);
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            if (this.block != null) {
                var1.addProperty("block", BuiltInRegistries.BLOCK.getKey(this.block).toString());
            }
            var1.add("state", this.state.serializeToJson());
            var1.add("location", this.location.serializeToJson());
            var1.add("item", this.item.serializeToJson());
            return var1;
        }
    }
}

