/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public abstract class CriterionTriggerAbstract<T extends CriterionInstanceAbstract>
implements CriterionTrigger<T> {
    private final Map<AdvancementDataPlayer, Set<CriterionTrigger.a<T>>> players = Maps.newIdentityHashMap();

    @Override
    public final void addPlayerListener(AdvancementDataPlayer var02, CriterionTrigger.a<T> var1) {
        this.players.computeIfAbsent(var02, var0 -> Sets.newHashSet()).add(var1);
    }

    @Override
    public final void removePlayerListener(AdvancementDataPlayer var0, CriterionTrigger.a<T> var1) {
        Set<CriterionTrigger.a<T>> var2 = this.players.get(var0);
        if (var2 != null) {
            var2.remove(var1);
            if (var2.isEmpty()) {
                this.players.remove(var0);
            }
        }
    }

    @Override
    public final void removePlayerListeners(AdvancementDataPlayer var0) {
        this.players.remove(var0);
    }

    protected abstract T createInstance(JsonObject var1, CriterionConditionEntity.b var2, LootDeserializationContext var3);

    @Override
    public final T createInstance(JsonObject var0, LootDeserializationContext var1) {
        CriterionConditionEntity.b var2 = CriterionConditionEntity.b.fromJson(var0, "player", var1);
        return this.createInstance(var0, var2, var1);
    }

    protected void trigger(EntityPlayer var0, Predicate<T> var1) {
        AdvancementDataPlayer var2 = var0.getAdvancements();
        Set<CriterionTrigger.a<T>> var3 = this.players.get(var2);
        if (var3 == null || var3.isEmpty()) {
            return;
        }
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var0);
        List var5 = null;
        for (CriterionTrigger.a<Object> var7 : var3) {
            CriterionInstanceAbstract var8 = (CriterionInstanceAbstract)var7.getTriggerInstance();
            if (!var1.test(var8) || !var8.getPlayerPredicate().matches(var4)) continue;
            if (var5 == null) {
                var5 = Lists.newArrayList();
            }
            var5.add(var7);
        }
        if (var5 != null) {
            for (CriterionTrigger.a<Object> var7 : var5) {
                var7.run(var2);
            }
        }
    }

    @Override
    public /* synthetic */ CriterionInstance createInstance(JsonObject jsonObject, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, lootDeserializationContext);
    }
}

