/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

public class CriterionConditionMobEffect {
    public static final CriterionConditionMobEffect ANY = new CriterionConditionMobEffect(Collections.emptyMap());
    private final Map<MobEffectList, a> effects;

    public CriterionConditionMobEffect(Map<MobEffectList, a> var0) {
        this.effects = var0;
    }

    public static CriterionConditionMobEffect effects() {
        return new CriterionConditionMobEffect(Maps.newLinkedHashMap());
    }

    public CriterionConditionMobEffect and(MobEffectList var0) {
        this.effects.put(var0, new a());
        return this;
    }

    public CriterionConditionMobEffect and(MobEffectList var0, a var1) {
        this.effects.put(var0, var1);
        return this;
    }

    public boolean matches(Entity var0) {
        if (this == ANY) {
            return true;
        }
        if (var0 instanceof EntityLiving) {
            return this.matches(((EntityLiving)var0).getActiveEffectsMap());
        }
        return false;
    }

    public boolean matches(EntityLiving var0) {
        if (this == ANY) {
            return true;
        }
        return this.matches(var0.getActiveEffectsMap());
    }

    public boolean matches(Map<MobEffectList, MobEffect> var0) {
        if (this == ANY) {
            return true;
        }
        for (Map.Entry<MobEffectList, a> var2 : this.effects.entrySet()) {
            MobEffect var3 = var0.get(var2.getKey());
            if (var2.getValue().matches(var3)) continue;
            return false;
        }
        return true;
    }

    public static CriterionConditionMobEffect fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "effects");
        LinkedHashMap var2 = Maps.newLinkedHashMap();
        for (Map.Entry var4 : var1.entrySet()) {
            MinecraftKey var5 = new MinecraftKey((String)var4.getKey());
            MobEffectList var6 = BuiltInRegistries.MOB_EFFECT.getOptional(var5).orElseThrow(() -> new JsonSyntaxException("Unknown effect '" + var5 + "'"));
            a var7 = a.fromJson(ChatDeserializer.convertToJsonObject((JsonElement)var4.getValue(), (String)var4.getKey()));
            var2.put(var6, var7);
        }
        return new CriterionConditionMobEffect(var2);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        for (Map.Entry<MobEffectList, a> var2 : this.effects.entrySet()) {
            var0.add(BuiltInRegistries.MOB_EFFECT.getKey(var2.getKey()).toString(), var2.getValue().serializeToJson());
        }
        return var0;
    }

    public static class a {
        private final CriterionConditionValue.IntegerRange amplifier;
        private final CriterionConditionValue.IntegerRange duration;
        @Nullable
        private final Boolean ambient;
        @Nullable
        private final Boolean visible;

        public a(CriterionConditionValue.IntegerRange var0, CriterionConditionValue.IntegerRange var1, @Nullable Boolean var2, @Nullable Boolean var3) {
            this.amplifier = var0;
            this.duration = var1;
            this.ambient = var2;
            this.visible = var3;
        }

        public a() {
            this(CriterionConditionValue.IntegerRange.ANY, CriterionConditionValue.IntegerRange.ANY, null, null);
        }

        public boolean matches(@Nullable MobEffect var0) {
            if (var0 == null) {
                return false;
            }
            if (!this.amplifier.matches(var0.getAmplifier())) {
                return false;
            }
            if (!this.duration.matches(var0.getDuration())) {
                return false;
            }
            if (this.ambient != null && this.ambient.booleanValue() != var0.isAmbient()) {
                return false;
            }
            return this.visible == null || this.visible.booleanValue() == var0.isVisible();
        }

        public JsonElement serializeToJson() {
            JsonObject var0 = new JsonObject();
            var0.add("amplifier", this.amplifier.serializeToJson());
            var0.add("duration", this.duration.serializeToJson());
            var0.addProperty("ambient", this.ambient);
            var0.addProperty("visible", this.visible);
            return var0;
        }

        public static a fromJson(JsonObject var0) {
            CriterionConditionValue.IntegerRange var1 = CriterionConditionValue.IntegerRange.fromJson(var0.get("amplifier"));
            CriterionConditionValue.IntegerRange var2 = CriterionConditionValue.IntegerRange.fromJson(var0.get("duration"));
            Boolean var3 = var0.has("ambient") ? Boolean.valueOf(ChatDeserializer.getAsBoolean(var0, "ambient")) : null;
            Boolean var4 = var0.has("visible") ? Boolean.valueOf(ChatDeserializer.getAsBoolean(var0, "visible")) : null;
            return new a(var1, var2, var3, var4);
        }
    }
}

