/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionInOpenWater
implements EntitySubPredicate {
    public static final CriterionConditionInOpenWater ANY = new CriterionConditionInOpenWater(false);
    private static final String IN_OPEN_WATER_KEY = "in_open_water";
    private final boolean inOpenWater;

    private CriterionConditionInOpenWater(boolean var0) {
        this.inOpenWater = var0;
    }

    public static CriterionConditionInOpenWater inOpenWater(boolean var0) {
        return new CriterionConditionInOpenWater(var0);
    }

    public static CriterionConditionInOpenWater fromJson(JsonObject var0) {
        JsonElement var1 = var0.get(IN_OPEN_WATER_KEY);
        if (var1 != null) {
            return new CriterionConditionInOpenWater(ChatDeserializer.convertToBoolean(var1, IN_OPEN_WATER_KEY));
        }
        return ANY;
    }

    @Override
    public JsonObject serializeCustomData() {
        if (this == ANY) {
            return new JsonObject();
        }
        JsonObject var0 = new JsonObject();
        var0.add(IN_OPEN_WATER_KEY, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.inOpenWater)));
        return var0;
    }

    @Override
    public EntitySubPredicate.a type() {
        return EntitySubPredicate.b.FISHING_HOOK;
    }

    @Override
    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
        if (this == ANY) {
            return true;
        }
        if (!(var0 instanceof EntityFishingHook)) {
            return false;
        }
        EntityFishingHook var3 = (EntityFishingHook)var0;
        return this.inOpenWater == var3.isOpenWaterFishing();
    }
}

