/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Items;

public class CriterionConditionEntityEquipment {
    public static final CriterionConditionEntityEquipment ANY = new CriterionConditionEntityEquipment(CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY);
    public static final CriterionConditionEntityEquipment CAPTAIN = new CriterionConditionEntityEquipment(CriterionConditionItem.a.item().of(Items.WHITE_BANNER).hasNbt(Raid.getLeaderBannerInstance().getTag()).build(), CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY, CriterionConditionItem.ANY);
    private final CriterionConditionItem head;
    private final CriterionConditionItem chest;
    private final CriterionConditionItem legs;
    private final CriterionConditionItem feet;
    private final CriterionConditionItem mainhand;
    private final CriterionConditionItem offhand;

    public CriterionConditionEntityEquipment(CriterionConditionItem var0, CriterionConditionItem var1, CriterionConditionItem var2, CriterionConditionItem var3, CriterionConditionItem var4, CriterionConditionItem var5) {
        this.head = var0;
        this.chest = var1;
        this.legs = var2;
        this.feet = var3;
        this.mainhand = var4;
        this.offhand = var5;
    }

    public boolean matches(@Nullable Entity var0) {
        if (this == ANY) {
            return true;
        }
        if (!(var0 instanceof EntityLiving)) {
            return false;
        }
        EntityLiving var1 = (EntityLiving)var0;
        if (!this.head.matches(var1.getItemBySlot(EnumItemSlot.HEAD))) {
            return false;
        }
        if (!this.chest.matches(var1.getItemBySlot(EnumItemSlot.CHEST))) {
            return false;
        }
        if (!this.legs.matches(var1.getItemBySlot(EnumItemSlot.LEGS))) {
            return false;
        }
        if (!this.feet.matches(var1.getItemBySlot(EnumItemSlot.FEET))) {
            return false;
        }
        if (!this.mainhand.matches(var1.getItemBySlot(EnumItemSlot.MAINHAND))) {
            return false;
        }
        return this.offhand.matches(var1.getItemBySlot(EnumItemSlot.OFFHAND));
    }

    public static CriterionConditionEntityEquipment fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "equipment");
        CriterionConditionItem var2 = CriterionConditionItem.fromJson(var1.get("head"));
        CriterionConditionItem var3 = CriterionConditionItem.fromJson(var1.get("chest"));
        CriterionConditionItem var4 = CriterionConditionItem.fromJson(var1.get("legs"));
        CriterionConditionItem var5 = CriterionConditionItem.fromJson(var1.get("feet"));
        CriterionConditionItem var6 = CriterionConditionItem.fromJson(var1.get("mainhand"));
        CriterionConditionItem var7 = CriterionConditionItem.fromJson(var1.get("offhand"));
        return new CriterionConditionEntityEquipment(var2, var3, var4, var5, var6, var7);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add("head", this.head.serializeToJson());
        var0.add("chest", this.chest.serializeToJson());
        var0.add("legs", this.legs.serializeToJson());
        var0.add("feet", this.feet.serializeToJson());
        var0.add("mainhand", this.mainhand.serializeToJson());
        var0.add("offhand", this.offhand.serializeToJson());
        return var0;
    }

    public static class a {
        private CriterionConditionItem head = CriterionConditionItem.ANY;
        private CriterionConditionItem chest = CriterionConditionItem.ANY;
        private CriterionConditionItem legs = CriterionConditionItem.ANY;
        private CriterionConditionItem feet = CriterionConditionItem.ANY;
        private CriterionConditionItem mainhand = CriterionConditionItem.ANY;
        private CriterionConditionItem offhand = CriterionConditionItem.ANY;

        public static a equipment() {
            return new a();
        }

        public a head(CriterionConditionItem var0) {
            this.head = var0;
            return this;
        }

        public a chest(CriterionConditionItem var0) {
            this.chest = var0;
            return this;
        }

        public a legs(CriterionConditionItem var0) {
            this.legs = var0;
            return this;
        }

        public a feet(CriterionConditionItem var0) {
            this.feet = var0;
            return this;
        }

        public a mainhand(CriterionConditionItem var0) {
            this.mainhand = var0;
            return this;
        }

        public a offhand(CriterionConditionItem var0) {
            this.offhand = var0;
            return this;
        }

        public CriterionConditionEntityEquipment build() {
            return new CriterionConditionEntityEquipment(this.head, this.chest, this.legs, this.feet, this.mainhand, this.offhand);
        }
    }
}

