/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionBlockStateProperty
implements LootItemCondition {
    final Block block;
    final CriterionTriggerProperties properties;

    LootItemConditionBlockStateProperty(Block var0, CriterionTriggerProperties var1) {
        this.block = var0;
        this.properties = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.BLOCK_STATE_PROPERTY;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.BLOCK_STATE);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        IBlockData var1 = var0.getParamOrNull(LootContextParameters.BLOCK_STATE);
        return var1 != null && var1.is(this.block) && this.properties.matches(var1);
    }

    public static a hasBlockStateProperties(Block var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final Block block;
        private CriterionTriggerProperties properties = CriterionTriggerProperties.ANY;

        public a(Block var0) {
            this.block = var0;
        }

        public a setProperties(CriterionTriggerProperties.a var0) {
            this.properties = var0.build();
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionBlockStateProperty(this.block, this.properties);
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionBlockStateProperty> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionBlockStateProperty var1, JsonSerializationContext var2) {
            var0.addProperty("block", IRegistry.BLOCK.getKey(var1.block).toString());
            var0.add("properties", var1.properties.serializeToJson());
        }

        @Override
        public LootItemConditionBlockStateProperty deserialize(JsonObject var0, JsonDeserializationContext var12) {
            MinecraftKey var2 = new MinecraftKey(ChatDeserializer.getAsString(var0, "block"));
            Block var3 = IRegistry.BLOCK.getOptional(var2).orElseThrow(() -> new IllegalArgumentException("Can't find block " + var2));
            CriterionTriggerProperties var4 = CriterionTriggerProperties.fromJson(var0.get("properties"));
            var4.checkState(var3.getStateDefinition(), var1 -> {
                throw new JsonSyntaxException("Block " + var3 + " has no property " + var1);
            });
            return new LootItemConditionBlockStateProperty(var3, var4);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

