/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.MinecraftKey;

public class LootTables {
    private static final Set<MinecraftKey> LOCATIONS = Sets.newHashSet();
    private static final Set<MinecraftKey> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final MinecraftKey EMPTY = new MinecraftKey("empty");
    public static final MinecraftKey SPAWN_BONUS_CHEST = LootTables.register("chests/spawn_bonus_chest");
    public static final MinecraftKey END_CITY_TREASURE = LootTables.register("chests/end_city_treasure");
    public static final MinecraftKey SIMPLE_DUNGEON = LootTables.register("chests/simple_dungeon");
    public static final MinecraftKey VILLAGE_WEAPONSMITH = LootTables.register("chests/village/village_weaponsmith");
    public static final MinecraftKey VILLAGE_TOOLSMITH = LootTables.register("chests/village/village_toolsmith");
    public static final MinecraftKey VILLAGE_ARMORER = LootTables.register("chests/village/village_armorer");
    public static final MinecraftKey VILLAGE_CARTOGRAPHER = LootTables.register("chests/village/village_cartographer");
    public static final MinecraftKey VILLAGE_MASON = LootTables.register("chests/village/village_mason");
    public static final MinecraftKey VILLAGE_SHEPHERD = LootTables.register("chests/village/village_shepherd");
    public static final MinecraftKey VILLAGE_BUTCHER = LootTables.register("chests/village/village_butcher");
    public static final MinecraftKey VILLAGE_FLETCHER = LootTables.register("chests/village/village_fletcher");
    public static final MinecraftKey VILLAGE_FISHER = LootTables.register("chests/village/village_fisher");
    public static final MinecraftKey VILLAGE_TANNERY = LootTables.register("chests/village/village_tannery");
    public static final MinecraftKey VILLAGE_TEMPLE = LootTables.register("chests/village/village_temple");
    public static final MinecraftKey VILLAGE_DESERT_HOUSE = LootTables.register("chests/village/village_desert_house");
    public static final MinecraftKey VILLAGE_PLAINS_HOUSE = LootTables.register("chests/village/village_plains_house");
    public static final MinecraftKey VILLAGE_TAIGA_HOUSE = LootTables.register("chests/village/village_taiga_house");
    public static final MinecraftKey VILLAGE_SNOWY_HOUSE = LootTables.register("chests/village/village_snowy_house");
    public static final MinecraftKey VILLAGE_SAVANNA_HOUSE = LootTables.register("chests/village/village_savanna_house");
    public static final MinecraftKey ABANDONED_MINESHAFT = LootTables.register("chests/abandoned_mineshaft");
    public static final MinecraftKey NETHER_BRIDGE = LootTables.register("chests/nether_bridge");
    public static final MinecraftKey STRONGHOLD_LIBRARY = LootTables.register("chests/stronghold_library");
    public static final MinecraftKey STRONGHOLD_CROSSING = LootTables.register("chests/stronghold_crossing");
    public static final MinecraftKey STRONGHOLD_CORRIDOR = LootTables.register("chests/stronghold_corridor");
    public static final MinecraftKey DESERT_PYRAMID = LootTables.register("chests/desert_pyramid");
    public static final MinecraftKey JUNGLE_TEMPLE = LootTables.register("chests/jungle_temple");
    public static final MinecraftKey JUNGLE_TEMPLE_DISPENSER = LootTables.register("chests/jungle_temple_dispenser");
    public static final MinecraftKey IGLOO_CHEST = LootTables.register("chests/igloo_chest");
    public static final MinecraftKey WOODLAND_MANSION = LootTables.register("chests/woodland_mansion");
    public static final MinecraftKey UNDERWATER_RUIN_SMALL = LootTables.register("chests/underwater_ruin_small");
    public static final MinecraftKey UNDERWATER_RUIN_BIG = LootTables.register("chests/underwater_ruin_big");
    public static final MinecraftKey BURIED_TREASURE = LootTables.register("chests/buried_treasure");
    public static final MinecraftKey SHIPWRECK_MAP = LootTables.register("chests/shipwreck_map");
    public static final MinecraftKey SHIPWRECK_SUPPLY = LootTables.register("chests/shipwreck_supply");
    public static final MinecraftKey SHIPWRECK_TREASURE = LootTables.register("chests/shipwreck_treasure");
    public static final MinecraftKey PILLAGER_OUTPOST = LootTables.register("chests/pillager_outpost");
    public static final MinecraftKey BASTION_TREASURE = LootTables.register("chests/bastion_treasure");
    public static final MinecraftKey BASTION_OTHER = LootTables.register("chests/bastion_other");
    public static final MinecraftKey BASTION_BRIDGE = LootTables.register("chests/bastion_bridge");
    public static final MinecraftKey BASTION_HOGLIN_STABLE = LootTables.register("chests/bastion_hoglin_stable");
    public static final MinecraftKey ANCIENT_CITY = LootTables.register("chests/ancient_city");
    public static final MinecraftKey ANCIENT_CITY_ICE_BOX = LootTables.register("chests/ancient_city_ice_box");
    public static final MinecraftKey RUINED_PORTAL = LootTables.register("chests/ruined_portal");
    public static final MinecraftKey SHEEP_WHITE = LootTables.register("entities/sheep/white");
    public static final MinecraftKey SHEEP_ORANGE = LootTables.register("entities/sheep/orange");
    public static final MinecraftKey SHEEP_MAGENTA = LootTables.register("entities/sheep/magenta");
    public static final MinecraftKey SHEEP_LIGHT_BLUE = LootTables.register("entities/sheep/light_blue");
    public static final MinecraftKey SHEEP_YELLOW = LootTables.register("entities/sheep/yellow");
    public static final MinecraftKey SHEEP_LIME = LootTables.register("entities/sheep/lime");
    public static final MinecraftKey SHEEP_PINK = LootTables.register("entities/sheep/pink");
    public static final MinecraftKey SHEEP_GRAY = LootTables.register("entities/sheep/gray");
    public static final MinecraftKey SHEEP_LIGHT_GRAY = LootTables.register("entities/sheep/light_gray");
    public static final MinecraftKey SHEEP_CYAN = LootTables.register("entities/sheep/cyan");
    public static final MinecraftKey SHEEP_PURPLE = LootTables.register("entities/sheep/purple");
    public static final MinecraftKey SHEEP_BLUE = LootTables.register("entities/sheep/blue");
    public static final MinecraftKey SHEEP_BROWN = LootTables.register("entities/sheep/brown");
    public static final MinecraftKey SHEEP_GREEN = LootTables.register("entities/sheep/green");
    public static final MinecraftKey SHEEP_RED = LootTables.register("entities/sheep/red");
    public static final MinecraftKey SHEEP_BLACK = LootTables.register("entities/sheep/black");
    public static final MinecraftKey FISHING = LootTables.register("gameplay/fishing");
    public static final MinecraftKey FISHING_JUNK = LootTables.register("gameplay/fishing/junk");
    public static final MinecraftKey FISHING_TREASURE = LootTables.register("gameplay/fishing/treasure");
    public static final MinecraftKey FISHING_FISH = LootTables.register("gameplay/fishing/fish");
    public static final MinecraftKey CAT_MORNING_GIFT = LootTables.register("gameplay/cat_morning_gift");
    public static final MinecraftKey ARMORER_GIFT = LootTables.register("gameplay/hero_of_the_village/armorer_gift");
    public static final MinecraftKey BUTCHER_GIFT = LootTables.register("gameplay/hero_of_the_village/butcher_gift");
    public static final MinecraftKey CARTOGRAPHER_GIFT = LootTables.register("gameplay/hero_of_the_village/cartographer_gift");
    public static final MinecraftKey CLERIC_GIFT = LootTables.register("gameplay/hero_of_the_village/cleric_gift");
    public static final MinecraftKey FARMER_GIFT = LootTables.register("gameplay/hero_of_the_village/farmer_gift");
    public static final MinecraftKey FISHERMAN_GIFT = LootTables.register("gameplay/hero_of_the_village/fisherman_gift");
    public static final MinecraftKey FLETCHER_GIFT = LootTables.register("gameplay/hero_of_the_village/fletcher_gift");
    public static final MinecraftKey LEATHERWORKER_GIFT = LootTables.register("gameplay/hero_of_the_village/leatherworker_gift");
    public static final MinecraftKey LIBRARIAN_GIFT = LootTables.register("gameplay/hero_of_the_village/librarian_gift");
    public static final MinecraftKey MASON_GIFT = LootTables.register("gameplay/hero_of_the_village/mason_gift");
    public static final MinecraftKey SHEPHERD_GIFT = LootTables.register("gameplay/hero_of_the_village/shepherd_gift");
    public static final MinecraftKey TOOLSMITH_GIFT = LootTables.register("gameplay/hero_of_the_village/toolsmith_gift");
    public static final MinecraftKey WEAPONSMITH_GIFT = LootTables.register("gameplay/hero_of_the_village/weaponsmith_gift");
    public static final MinecraftKey PIGLIN_BARTERING = LootTables.register("gameplay/piglin_bartering");

    private static MinecraftKey register(String var0) {
        return LootTables.register(new MinecraftKey(var0));
    }

    private static MinecraftKey register(MinecraftKey var0) {
        if (LOCATIONS.add(var0)) {
            return var0;
        }
        throw new IllegalArgumentException(var0 + " is already a registered built-in loot table");
    }

    public static Set<MinecraftKey> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

