/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class IntRange {
    @Nullable
    final NumberProvider min;
    @Nullable
    final NumberProvider max;
    private final b limiter;
    private final a predicate;

    public Set<LootContextParameter<?>> getReferencedContextParams() {
        ImmutableSet.Builder var0 = ImmutableSet.builder();
        if (this.min != null) {
            var0.addAll(this.min.getReferencedContextParams());
        }
        if (this.max != null) {
            var0.addAll(this.max.getReferencedContextParams());
        }
        return var0.build();
    }

    IntRange(@Nullable NumberProvider var02, @Nullable NumberProvider var12) {
        this.min = var02;
        this.max = var12;
        if (var02 == null) {
            if (var12 == null) {
                this.limiter = (var0, var1) -> var1;
                this.predicate = (var0, var1) -> true;
            } else {
                this.limiter = (var1, var2) -> Math.min(var12.getInt(var1), var2);
                this.predicate = (var1, var2) -> var2 <= var12.getInt(var1);
            }
        } else if (var12 == null) {
            this.limiter = (var1, var2) -> Math.max(var02.getInt(var1), var2);
            this.predicate = (var1, var2) -> var2 >= var02.getInt(var1);
        } else {
            this.limiter = (var2, var3) -> MathHelper.clamp(var3, var02.getInt(var2), var12.getInt(var2));
            this.predicate = (var2, var3) -> var3 >= var02.getInt(var2) && var3 <= var12.getInt(var2);
        }
    }

    public static IntRange exact(int var0) {
        ConstantValue var1 = ConstantValue.exactly(var0);
        return new IntRange(var1, var1);
    }

    public static IntRange range(int var0, int var1) {
        return new IntRange(ConstantValue.exactly(var0), ConstantValue.exactly(var1));
    }

    public static IntRange lowerBound(int var0) {
        return new IntRange(ConstantValue.exactly(var0), null);
    }

    public static IntRange upperBound(int var0) {
        return new IntRange(null, ConstantValue.exactly(var0));
    }

    public int clamp(LootTableInfo var0, int var1) {
        return this.limiter.apply(var0, var1);
    }

    public boolean test(LootTableInfo var0, int var1) {
        return this.predicate.test(var0, var1);
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }

    public static class c
    implements JsonDeserializer<IntRange>,
    JsonSerializer<IntRange> {
        public IntRange deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) {
            if (var0.isJsonPrimitive()) {
                return IntRange.exact(var0.getAsInt());
            }
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "value");
            NumberProvider var4 = var3.has("min") ? ChatDeserializer.getAsObject(var3, "min", var2, NumberProvider.class) : null;
            NumberProvider var5 = var3.has("max") ? ChatDeserializer.getAsObject(var3, "max", var2, NumberProvider.class) : null;
            return new IntRange(var4, var5);
        }

        public JsonElement serialize(IntRange var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            if (Objects.equals(var0.max, var0.min)) {
                return var2.serialize((Object)var0.min);
            }
            if (var0.max != null) {
                var3.add("max", var2.serialize((Object)var0.max));
            }
            if (var0.min != null) {
                var3.add("min", var2.serialize((Object)var0.min));
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((IntRange)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

