/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraft.world.level.pathfinder.PathPoint;

public class Path {
    private PathPoint[] heap = new PathPoint[128];
    private int size;

    public PathPoint insert(PathPoint var0) {
        if (var0.heapIdx >= 0) {
            throw new IllegalStateException("OW KNOWS!");
        }
        if (this.size == this.heap.length) {
            PathPoint[] var1 = new PathPoint[this.size << 1];
            System.arraycopy(this.heap, 0, var1, 0, this.size);
            this.heap = var1;
        }
        this.heap[this.size] = var0;
        var0.heapIdx = this.size;
        this.upHeap(this.size++);
        return var0;
    }

    public void clear() {
        this.size = 0;
    }

    public PathPoint peek() {
        return this.heap[0];
    }

    public PathPoint pop() {
        PathPoint var0 = this.heap[0];
        this.heap[0] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > 0) {
            this.downHeap(0);
        }
        var0.heapIdx = -1;
        return var0;
    }

    public void remove(PathPoint var0) {
        this.heap[var0.heapIdx] = this.heap[--this.size];
        this.heap[this.size] = null;
        if (this.size > var0.heapIdx) {
            if (this.heap[var0.heapIdx].f < var0.f) {
                this.upHeap(var0.heapIdx);
            } else {
                this.downHeap(var0.heapIdx);
            }
        }
        var0.heapIdx = -1;
    }

    public void changeCost(PathPoint var0, float var1) {
        float var2 = var0.f;
        var0.f = var1;
        if (var1 < var2) {
            this.upHeap(var0.heapIdx);
        } else {
            this.downHeap(var0.heapIdx);
        }
    }

    public int size() {
        return this.size;
    }

    private void upHeap(int var0) {
        PathPoint var1 = this.heap[var0];
        float var2 = var1.f;
        while (var0 > 0) {
            int var3 = var0 - 1 >> 1;
            PathPoint var4 = this.heap[var3];
            if (!(var2 < var4.f)) break;
            this.heap[var0] = var4;
            var4.heapIdx = var0;
            var0 = var3;
        }
        this.heap[var0] = var1;
        var1.heapIdx = var0;
    }

    private void downHeap(int var0) {
        PathPoint var1 = this.heap[var0];
        float var2 = var1.f;
        while (true) {
            float var8;
            PathPoint var7;
            int var3 = 1 + (var0 << 1);
            int var4 = var3 + 1;
            if (var3 >= this.size) break;
            PathPoint var5 = this.heap[var3];
            float var6 = var5.f;
            if (var4 >= this.size) {
                var7 = null;
                var8 = Float.POSITIVE_INFINITY;
            } else {
                var7 = this.heap[var4];
                var8 = var7.f;
            }
            if (var6 < var8) {
                if (!(var6 < var2)) break;
                this.heap[var0] = var5;
                var5.heapIdx = var0;
                var0 = var3;
                continue;
            }
            if (!(var8 < var2)) break;
            this.heap[var0] = var7;
            var7.heapIdx = var0;
            var0 = var4;
        }
        this.heap[var0] = var1;
        var1.heapIdx = var0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public PathPoint[] getHeap() {
        PathPoint[] var0 = new PathPoint[this.size()];
        System.arraycopy(this.heap, 0, var0, 0, this.size());
        return var0;
    }
}

