/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorageSky;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;

public final class LightEngineSky
extends LightEngineLayer<LightEngineStorageSky.a, LightEngineStorageSky> {
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private static final EnumDirection[] HORIZONTALS = new EnumDirection[]{EnumDirection.NORTH, EnumDirection.SOUTH, EnumDirection.WEST, EnumDirection.EAST};

    public LightEngineSky(ILightAccess var0) {
        super(var0, EnumSkyBlock.SKY, new LightEngineStorageSky(var0));
    }

    @Override
    protected int computeLevelFromNeighbor(long var0, long var2, int var4) {
        boolean var21;
        VoxelShape var19;
        int var15;
        int var14;
        if (var2 == Long.MAX_VALUE || var0 == Long.MAX_VALUE) {
            return 15;
        }
        if (var4 >= 15) {
            return var4;
        }
        MutableInt var5 = new MutableInt();
        IBlockData var6 = this.getStateAndOpacity(var2, var5);
        if (var5.getValue() >= 15) {
            return 15;
        }
        int var7 = BlockPosition.getX(var0);
        int var8 = BlockPosition.getY(var0);
        int var9 = BlockPosition.getZ(var0);
        int var10 = BlockPosition.getX(var2);
        int var11 = BlockPosition.getY(var2);
        int var12 = BlockPosition.getZ(var2);
        int var13 = Integer.signum(var10 - var7);
        EnumDirection var16 = EnumDirection.fromNormal(var13, var14 = Integer.signum(var11 - var8), var15 = Integer.signum(var12 - var9));
        if (var16 == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Light was spread in illegal direction %d, %d, %d", var13, var14, var15));
        }
        IBlockData var17 = this.getStateAndOpacity(var0, null);
        VoxelShape var18 = this.getShape(var17, var0, var16);
        if (VoxelShapes.faceShapeOccludes(var18, var19 = this.getShape(var6, var2, var16.getOpposite()))) {
            return 15;
        }
        boolean var20 = var7 == var10 && var9 == var12;
        boolean bl = var21 = var20 && var8 > var11;
        if (var21 && var4 == 0 && var5.getValue() == 0) {
            return 0;
        }
        return var4 + Math.max(1, var5.getValue());
    }

    @Override
    protected void checkNeighborsAfterUpdate(long var0, int var2, boolean var3) {
        long var14;
        long var16;
        int var9;
        long var4 = SectionPosition.blockToSection(var0);
        int var6 = BlockPosition.getY(var0);
        int var7 = SectionPosition.sectionRelative(var6);
        int var8 = SectionPosition.blockToSectionCoord(var6);
        if (var7 != 0) {
            var9 = 0;
        } else {
            int var10 = 0;
            while (!((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.offset(var4, 0, -var10 - 1, 0)) && ((LightEngineStorageSky)this.storage).hasSectionsBelow(var8 - var10 - 1)) {
                ++var10;
            }
            var9 = var10;
        }
        long var10 = BlockPosition.offset(var0, 0, -1 - var9 * 16, 0);
        long var12 = SectionPosition.blockToSection(var10);
        if (var4 == var12 || ((LightEngineStorageSky)this.storage).storingLightForSection(var12)) {
            this.checkNeighbor(var0, var10, var2, var3);
        }
        if (var4 == (var16 = SectionPosition.blockToSection(var14 = BlockPosition.offset(var0, EnumDirection.UP))) || ((LightEngineStorageSky)this.storage).storingLightForSection(var16)) {
            this.checkNeighbor(var0, var14, var2, var3);
        }
        block1: for (EnumDirection var21 : HORIZONTALS) {
            int var22 = 0;
            do {
                long var23;
                long var25;
                if (var4 == (var25 = SectionPosition.blockToSection(var23 = BlockPosition.offset(var0, var21.getStepX(), -var22, var21.getStepZ())))) {
                    this.checkNeighbor(var0, var23, var2, var3);
                    continue block1;
                }
                if (!((LightEngineStorageSky)this.storage).storingLightForSection(var25)) continue;
                long var27 = BlockPosition.offset(var0, 0, -var22, 0);
                this.checkNeighbor(var27, var23, var2, var3);
            } while (++var22 <= var9 * 16);
        }
    }

    @Override
    protected int getComputedLevel(long var0, long var2, int var4) {
        int var5 = var4;
        long var6 = SectionPosition.blockToSection(var0);
        NibbleArray var8 = ((LightEngineStorageSky)this.storage).getDataLayer(var6, true);
        for (EnumDirection var12 : DIRECTIONS) {
            int var18;
            long var13 = BlockPosition.offset(var0, var12);
            if (var13 == var2) continue;
            long var15 = SectionPosition.blockToSection(var13);
            NibbleArray var17 = var6 == var15 ? var8 : ((LightEngineStorageSky)this.storage).getDataLayer(var15, true);
            if (var17 != null) {
                var18 = this.getLevel(var17, var13);
            } else {
                if (var12 == EnumDirection.DOWN) continue;
                var18 = 15 - ((LightEngineStorageSky)this.storage).getLightValue(var13, true);
            }
            int var19 = this.computeLevelFromNeighbor(var13, var0, var18);
            if (var5 > var19) {
                var5 = var19;
            }
            if (var5 != 0) continue;
            return var5;
        }
        return var5;
    }

    @Override
    protected void checkNode(long var0) {
        ((LightEngineStorageSky)this.storage).runAllUpdates();
        long var2 = SectionPosition.blockToSection(var0);
        if (((LightEngineStorageSky)this.storage).storingLightForSection(var2)) {
            super.checkNode(var0);
        } else {
            var0 = BlockPosition.getFlatIndex(var0);
            while (!((LightEngineStorageSky)this.storage).storingLightForSection(var2) && !((LightEngineStorageSky)this.storage).isAboveData(var2)) {
                var2 = SectionPosition.offset(var2, EnumDirection.UP);
                var0 = BlockPosition.offset(var0, 0, 16, 0);
            }
            if (((LightEngineStorageSky)this.storage).storingLightForSection(var2)) {
                super.checkNode(var0);
            }
        }
    }

    @Override
    public String getDebugData(long var0) {
        return super.getDebugData(var0) + (((LightEngineStorageSky)this.storage).isAboveData(var0) ? "*" : "");
    }
}

