/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorRotation
extends DefinedStructureProcessor {
    public static final Codec<DefinedStructureProcessorRotation> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)RegistryCodecs.homogeneousList(IRegistry.BLOCK_REGISTRY).optionalFieldOf("rottable_blocks").forGetter(var0 -> var0.rottableBlocks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("integrity").forGetter(var0 -> Float.valueOf(var0.integrity))).apply((Applicative)var02, DefinedStructureProcessorRotation::new));
    private Optional<HolderSet<Block>> rottableBlocks;
    private final float integrity;

    public DefinedStructureProcessorRotation(TagKey<Block> var0, float var1) {
        this(Optional.of(IRegistry.BLOCK.getOrCreateTag(var0)), var1);
    }

    public DefinedStructureProcessorRotation(float var0) {
        this(Optional.empty(), var0);
    }

    private DefinedStructureProcessorRotation(Optional<HolderSet<Block>> var0, float var1) {
        this.integrity = var1;
        this.rottableBlocks = var0;
    }

    @Override
    @Nullable
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        RandomSource var6 = var5.getRandom(var4.pos);
        if (this.rottableBlocks.isPresent() && !var3.state.is(this.rottableBlocks.get()) || var6.nextFloat() <= this.integrity) {
            return var4;
        }
        return null;
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.BLOCK_ROT;
    }
}

