/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.ShipwreckPieces;

public class ShipwreckStructure
extends Structure {
    public static final Codec<ShipwreckStructure> CODEC = RecordCodecBuilder.create(var02 -> var02.group(ShipwreckStructure.settingsCodec(var02), (App)Codec.BOOL.fieldOf("is_beached").forGetter(var0 -> var0.isBeached)).apply((Applicative)var02, ShipwreckStructure::new));
    public final boolean isBeached;

    public ShipwreckStructure(Structure.c var0, boolean var1) {
        super(var0);
        this.isBeached = var1;
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        HeightMap.Type var12 = this.isBeached ? HeightMap.Type.WORLD_SURFACE_WG : HeightMap.Type.OCEAN_FLOOR_WG;
        return ShipwreckStructure.onTopOfChunkCenter(var0, var12, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        EnumBlockRotation var2 = EnumBlockRotation.getRandom(var1.random());
        BlockPosition var3 = new BlockPosition(var1.chunkPos().getMinBlockX(), 90, var1.chunkPos().getMinBlockZ());
        ShipwreckPieces.addPieces(var1.structureTemplateManager(), var3, var2, var0, var1.random(), this.isBeached);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.SHIPWRECK;
    }
}

