/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NetherFossilPieces {
    private static final MinecraftKey[] FOSSILS = new MinecraftKey[]{new MinecraftKey("nether_fossils/fossil_1"), new MinecraftKey("nether_fossils/fossil_2"), new MinecraftKey("nether_fossils/fossil_3"), new MinecraftKey("nether_fossils/fossil_4"), new MinecraftKey("nether_fossils/fossil_5"), new MinecraftKey("nether_fossils/fossil_6"), new MinecraftKey("nether_fossils/fossil_7"), new MinecraftKey("nether_fossils/fossil_8"), new MinecraftKey("nether_fossils/fossil_9"), new MinecraftKey("nether_fossils/fossil_10"), new MinecraftKey("nether_fossils/fossil_11"), new MinecraftKey("nether_fossils/fossil_12"), new MinecraftKey("nether_fossils/fossil_13"), new MinecraftKey("nether_fossils/fossil_14")};

    public static void addPieces(StructureTemplateManager var0, StructurePieceAccessor var1, RandomSource var2, BlockPosition var3) {
        EnumBlockRotation var4 = EnumBlockRotation.getRandom(var2);
        var1.addPiece(new a(var0, SystemUtils.getRandom(FOSSILS, var2), var3, var4));
    }

    public static class a
    extends DefinedStructurePiece {
        public a(StructureTemplateManager var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FOSSIL, 0, var0, var1, var1.toString(), a.makeSettings(var3), var2);
        }

        public a(StructureTemplateManager var0, NBTTagCompound var12) {
            super(WorldGenFeatureStructurePieceType.NETHER_FOSSIL, var12, var0, (MinecraftKey var1) -> a.makeSettings(EnumBlockRotation.valueOf(var12.getString("Rot"))));
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation var0) {
            return new DefinedStructureInfo().setRotation(var0).setMirror(EnumBlockMirror.NONE).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putString("Rot", this.placeSettings.getRotation().name());
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            var4.encapsulate(this.template.getBoundingBox(this.placeSettings, this.templatePosition));
            super.postProcess(var0, var1, var2, var3, var4, var5, var6);
        }
    }
}

