/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.presets;

import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class WorldPresets {
    public static final ResourceKey<WorldPreset> NORMAL = WorldPresets.register("normal");
    public static final ResourceKey<WorldPreset> FLAT = WorldPresets.register("flat");
    public static final ResourceKey<WorldPreset> LARGE_BIOMES = WorldPresets.register("large_biomes");
    public static final ResourceKey<WorldPreset> AMPLIFIED = WorldPresets.register("amplified");
    public static final ResourceKey<WorldPreset> SINGLE_BIOME_SURFACE = WorldPresets.register("single_biome_surface");
    public static final ResourceKey<WorldPreset> DEBUG = WorldPresets.register("debug_all_block_states");

    public static Holder<WorldPreset> bootstrap(IRegistry<WorldPreset> var0) {
        return new a(var0).run();
    }

    private static ResourceKey<WorldPreset> register(String var0) {
        return ResourceKey.create(IRegistry.WORLD_PRESET_REGISTRY, new MinecraftKey(var0));
    }

    public static Optional<ResourceKey<WorldPreset>> fromSettings(GeneratorSettings var0) {
        ChunkGenerator var1 = var0.overworld();
        if (var1 instanceof ChunkProviderFlat) {
            return Optional.of(FLAT);
        }
        if (var1 instanceof ChunkProviderDebug) {
            return Optional.of(DEBUG);
        }
        return Optional.empty();
    }

    public static GeneratorSettings createNormalWorldFromPreset(IRegistryCustom var0, long var1, boolean var3, boolean var4) {
        return var0.registryOrThrow(IRegistry.WORLD_PRESET_REGISTRY).getHolderOrThrow(NORMAL).value().createWorldGenSettings(var1, var3, var4);
    }

    public static GeneratorSettings createNormalWorldFromPreset(IRegistryCustom var0, long var1) {
        return WorldPresets.createNormalWorldFromPreset(var0, var1, true, false);
    }

    public static GeneratorSettings createNormalWorldFromPreset(IRegistryCustom var0) {
        return WorldPresets.createNormalWorldFromPreset(var0, RandomSource.create().nextLong());
    }

    public static GeneratorSettings demoSettings(IRegistryCustom var0) {
        return WorldPresets.createNormalWorldFromPreset(var0, "North Carolina".hashCode(), true, true);
    }

    public static WorldDimension getNormalOverworld(IRegistryCustom var0) {
        return var0.registryOrThrow(IRegistry.WORLD_PRESET_REGISTRY).getHolderOrThrow(NORMAL).value().overworldOrThrow();
    }

    static class a {
        private final IRegistry<WorldPreset> presets;
        private final IRegistry<DimensionManager> dimensionTypes = RegistryGeneration.DIMENSION_TYPE;
        private final IRegistry<BiomeBase> biomes = RegistryGeneration.BIOME;
        private final IRegistry<StructureSet> structureSets = RegistryGeneration.STRUCTURE_SETS;
        private final IRegistry<GeneratorSettingBase> noiseSettings = RegistryGeneration.NOISE_GENERATOR_SETTINGS;
        private final IRegistry<NoiseGeneratorNormal.a> noises = RegistryGeneration.NOISE;
        private final Holder<DimensionManager> overworldDimensionType = this.dimensionTypes.getOrCreateHolderOrThrow(BuiltinDimensionTypes.OVERWORLD);
        private final Holder<DimensionManager> netherDimensionType = this.dimensionTypes.getOrCreateHolderOrThrow(BuiltinDimensionTypes.NETHER);
        private final Holder<GeneratorSettingBase> netherNoiseSettings = this.noiseSettings.getOrCreateHolderOrThrow(GeneratorSettingBase.NETHER);
        private final WorldDimension netherStem = new WorldDimension(this.netherDimensionType, new ChunkGeneratorAbstract(this.structureSets, this.noises, (WorldChunkManager)WorldChunkManagerMultiNoise.a.NETHER.biomeSource(this.biomes), this.netherNoiseSettings));
        private final Holder<DimensionManager> endDimensionType = this.dimensionTypes.getOrCreateHolderOrThrow(BuiltinDimensionTypes.END);
        private final Holder<GeneratorSettingBase> endNoiseSettings = this.noiseSettings.getOrCreateHolderOrThrow(GeneratorSettingBase.END);
        private final WorldDimension endStem = new WorldDimension(this.endDimensionType, new ChunkGeneratorAbstract(this.structureSets, this.noises, (WorldChunkManager)new WorldChunkManagerTheEnd(this.biomes), this.endNoiseSettings));

        a(IRegistry<WorldPreset> var0) {
            this.presets = var0;
        }

        private WorldDimension makeOverworld(ChunkGenerator var0) {
            return new WorldDimension(this.overworldDimensionType, var0);
        }

        private WorldDimension makeNoiseBasedOverworld(WorldChunkManager var0, Holder<GeneratorSettingBase> var1) {
            return this.makeOverworld(new ChunkGeneratorAbstract(this.structureSets, this.noises, var0, var1));
        }

        private WorldPreset createPresetWithCustomOverworld(WorldDimension var0) {
            return new WorldPreset(Map.of(WorldDimension.OVERWORLD, var0, WorldDimension.NETHER, this.netherStem, WorldDimension.END, this.endStem));
        }

        private Holder<WorldPreset> registerCustomOverworldPreset(ResourceKey<WorldPreset> var0, WorldDimension var1) {
            return RegistryGeneration.register(this.presets, var0, this.createPresetWithCustomOverworld(var1));
        }

        public Holder<WorldPreset> run() {
            WorldChunkManagerMultiNoise var0 = WorldChunkManagerMultiNoise.a.OVERWORLD.biomeSource(this.biomes);
            Holder<GeneratorSettingBase> var1 = this.noiseSettings.getOrCreateHolderOrThrow(GeneratorSettingBase.OVERWORLD);
            this.registerCustomOverworldPreset(NORMAL, this.makeNoiseBasedOverworld(var0, var1));
            Holder<GeneratorSettingBase> var2 = this.noiseSettings.getOrCreateHolderOrThrow(GeneratorSettingBase.LARGE_BIOMES);
            this.registerCustomOverworldPreset(LARGE_BIOMES, this.makeNoiseBasedOverworld(var0, var2));
            Holder<GeneratorSettingBase> var3 = this.noiseSettings.getOrCreateHolderOrThrow(GeneratorSettingBase.AMPLIFIED);
            this.registerCustomOverworldPreset(AMPLIFIED, this.makeNoiseBasedOverworld(var0, var3));
            this.registerCustomOverworldPreset(SINGLE_BIOME_SURFACE, this.makeNoiseBasedOverworld(new WorldChunkManagerHell(this.biomes.getOrCreateHolderOrThrow(Biomes.PLAINS)), var1));
            this.registerCustomOverworldPreset(FLAT, this.makeOverworld(new ChunkProviderFlat(this.structureSets, GeneratorSettingsFlat.getDefault(this.biomes, this.structureSets))));
            return this.registerCustomOverworldPreset(DEBUG, this.makeOverworld(new ChunkProviderDebug(this.structureSets, this.biomes)));
        }
    }
}

