/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> CODEC = IRegistry.ROOT_PLACER_TYPES.byNameCodec().dispatch(RootPlacer::type, RootPlacerType::codec);
    protected final IntProvider trunkOffsetY;
    protected final WorldGenFeatureStateProvider rootProvider;
    protected final Optional<AboveRootPlacement> aboveRootPlacement;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, WorldGenFeatureStateProvider, Optional<AboveRootPlacement>> rootPlacerParts(RecordCodecBuilder.Instance<P> var02) {
        return var02.group((App)IntProvider.CODEC.fieldOf("trunk_offset_y").forGetter(var0 -> var0.trunkOffsetY), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("root_provider").forGetter(var0 -> var0.rootProvider), (App)AboveRootPlacement.CODEC.optionalFieldOf("above_root_placement").forGetter(var0 -> var0.aboveRootPlacement));
    }

    public RootPlacer(IntProvider var0, WorldGenFeatureStateProvider var1, Optional<AboveRootPlacement> var2) {
        this.trunkOffsetY = var0;
        this.rootProvider = var1;
        this.aboveRootPlacement = var2;
    }

    protected abstract RootPlacerType<?> type();

    public abstract boolean placeRoots(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, RandomSource var3, BlockPosition var4, BlockPosition var5, WorldGenFeatureTreeConfiguration var6);

    protected boolean canPlaceRoot(VirtualLevelReadable var0, BlockPosition var1) {
        return WorldGenTrees.validTreePos(var0, var1);
    }

    protected void placeRoot(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, BlockPosition var3, WorldGenFeatureTreeConfiguration var4) {
        if (!this.canPlaceRoot(var0, var3)) {
            return;
        }
        var1.accept(var3, this.getPotentiallyWaterloggedState(var0, var3, this.rootProvider.getState(var2, var3)));
        if (this.aboveRootPlacement.isPresent()) {
            AboveRootPlacement var5 = this.aboveRootPlacement.get();
            BlockPosition var6 = var3.above();
            if (var2.nextFloat() < var5.aboveRootPlacementChance() && var0.isStateAtPosition(var6, BlockBase.BlockData::isAir)) {
                var1.accept(var6, this.getPotentiallyWaterloggedState(var0, var6, var5.aboveRootProvider().getState(var2, var6)));
            }
        }
    }

    protected IBlockData getPotentiallyWaterloggedState(VirtualLevelReadable var02, BlockPosition var1, IBlockData var2) {
        if (var2.hasProperty(BlockProperties.WATERLOGGED)) {
            boolean var3 = var02.isFluidAtPosition(var1, var0 -> var0.is(TagsFluid.WATER));
            return (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, var3);
        }
        return var2;
    }

    public BlockPosition getTrunkOrigin(BlockPosition var0, RandomSource var1) {
        return var0.above(this.trunkOffsetY.sample(var1));
    }
}

