/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class WorldGenFoilagePlacerDarkOak
extends WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacerDarkOak> CODEC = RecordCodecBuilder.create(var0 -> WorldGenFoilagePlacerDarkOak.foliagePlacerParts(var0).apply((Applicative)var0, WorldGenFoilagePlacerDarkOak::new));

    public WorldGenFoilagePlacerDarkOak(IntProvider var0, IntProvider var1) {
        super(var0, var1);
    }

    @Override
    protected WorldGenFoilagePlacers<?> type() {
        return WorldGenFoilagePlacers.DARK_OAK_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, int var4, WorldGenFoilagePlacer.a var5, int var6, int var7, int var8) {
        BlockPosition var9 = var5.pos().above(var8);
        boolean var10 = var5.doubleTrunk();
        if (var10) {
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, -1, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 3, 0, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, 1, var10);
            if (var2.nextBoolean()) {
                this.placeLeavesRow(var0, var1, var2, var3, var9, var7, 2, var10);
            }
        } else {
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 2, -1, var10);
            this.placeLeavesRow(var0, var1, var2, var3, var9, var7 + 1, 0, var10);
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, WorldGenFeatureTreeConfiguration var2) {
        return 4;
    }

    @Override
    protected boolean shouldSkipLocationSigned(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        if (!(var2 != 0 || !var5 || var1 != -var4 && var1 < var4 || var3 != -var4 && var3 < var4)) {
            return true;
        }
        return super.shouldSkipLocationSigned(var0, var1, var2, var3, var4, var5);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        if (var2 == -1 && !var5) {
            return var1 == var4 && var3 == var4;
        }
        if (var2 == 1) {
            return var1 + var3 > var4 * 2 - 2;
        }
        return false;
    }
}

