/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public class RandomSpreadFoliagePlacer
extends WorldGenFoilagePlacer {
    public static final Codec<RandomSpreadFoliagePlacer> CODEC = RecordCodecBuilder.create(var02 -> RandomSpreadFoliagePlacer.foliagePlacerParts(var02).and(var02.group((App)IntProvider.codec(1, 512).fieldOf("foliage_height").forGetter(var0 -> var0.foliageHeight), (App)Codec.intRange((int)0, (int)256).fieldOf("leaf_placement_attempts").forGetter(var0 -> var0.leafPlacementAttempts))).apply((Applicative)var02, RandomSpreadFoliagePlacer::new));
    private final IntProvider foliageHeight;
    private final int leafPlacementAttempts;

    public RandomSpreadFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2, int var3) {
        super(var0, var1);
        this.foliageHeight = var2;
        this.leafPlacementAttempts = var3;
    }

    @Override
    protected WorldGenFoilagePlacers<?> type() {
        return WorldGenFoilagePlacers.RANDOM_SPREAD_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, RandomSource var2, WorldGenFeatureTreeConfiguration var3, int var4, WorldGenFoilagePlacer.a var5, int var6, int var7, int var8) {
        BlockPosition var9 = var5.pos();
        BlockPosition.MutableBlockPosition var10 = var9.mutable();
        for (int var11 = 0; var11 < this.leafPlacementAttempts; ++var11) {
            var10.setWithOffset(var9, var2.nextInt(var7) - var2.nextInt(var7), var2.nextInt(var6) - var2.nextInt(var6), var2.nextInt(var7) - var2.nextInt(var7));
            RandomSpreadFoliagePlacer.tryPlaceLeaf(var0, var1, var2, var3, var10);
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, WorldGenFeatureTreeConfiguration var2) {
        return this.foliageHeight.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return false;
    }
}

