/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.primitives.Doubles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class BlendingData {
    private static final double BLENDING_DENSITY_FACTOR = 0.1;
    protected static final int CELL_WIDTH = 4;
    protected static final int CELL_HEIGHT = 8;
    protected static final int CELL_RATIO = 2;
    private static final double SOLID_DENSITY = 1.0;
    private static final double AIR_DENSITY = -1.0;
    private static final int CELLS_PER_SECTION_Y = 2;
    private static final int QUARTS_PER_SECTION = QuartPos.fromBlock(16);
    private static final int CELL_HORIZONTAL_MAX_INDEX_INSIDE = QUARTS_PER_SECTION - 1;
    private static final int CELL_HORIZONTAL_MAX_INDEX_OUTSIDE = QUARTS_PER_SECTION;
    private static final int CELL_COLUMN_INSIDE_COUNT = 2 * CELL_HORIZONTAL_MAX_INDEX_INSIDE + 1;
    private static final int CELL_COLUMN_OUTSIDE_COUNT = 2 * CELL_HORIZONTAL_MAX_INDEX_OUTSIDE + 1;
    private static final int CELL_COLUMN_COUNT = CELL_COLUMN_INSIDE_COUNT + CELL_COLUMN_OUTSIDE_COUNT;
    private final LevelHeightAccessor areaWithOldGeneration;
    private static final List<Block> SURFACE_BLOCKS = List.of(Blocks.PODZOL, Blocks.GRAVEL, Blocks.GRASS_BLOCK, Blocks.STONE, Blocks.COARSE_DIRT, Blocks.SAND, Blocks.RED_SAND, Blocks.MYCELIUM, Blocks.SNOW_BLOCK, Blocks.TERRACOTTA, Blocks.DIRT);
    protected static final double NO_VALUE = Double.MAX_VALUE;
    private boolean hasCalculatedData;
    private final double[] heights;
    private final List<List<Holder<BiomeBase>>> biomes;
    private final transient double[][] densities;
    private static final Codec<double[]> DOUBLE_ARRAY_CODEC = Codec.DOUBLE.listOf().xmap(Doubles::toArray, Doubles::asList);
    public static final Codec<BlendingData> CODEC = RecordCodecBuilder.create(var03 -> var03.group((App)Codec.INT.fieldOf("min_section").forGetter(var0 -> var0.areaWithOldGeneration.getMinSection()), (App)Codec.INT.fieldOf("max_section").forGetter(var0 -> var0.areaWithOldGeneration.getMaxSection()), (App)DOUBLE_ARRAY_CODEC.optionalFieldOf("heights").forGetter(var02 -> DoubleStream.of(var02.heights).anyMatch(var0 -> var0 != Double.MAX_VALUE) ? Optional.of(var02.heights) : Optional.empty())).apply((Applicative)var03, BlendingData::new)).comapFlatMap(BlendingData::validateArraySize, Function.identity());

    private static DataResult<BlendingData> validateArraySize(BlendingData var0) {
        if (var0.heights.length != CELL_COLUMN_COUNT) {
            return DataResult.error((String)("heights has to be of length " + CELL_COLUMN_COUNT));
        }
        return DataResult.success((Object)var0);
    }

    private BlendingData(int var02, int var1, Optional<double[]> var2) {
        this.heights = var2.orElse(SystemUtils.make(new double[CELL_COLUMN_COUNT], var0 -> Arrays.fill(var0, Double.MAX_VALUE)));
        this.densities = new double[CELL_COLUMN_COUNT][];
        ObjectArrayList var3 = new ObjectArrayList(CELL_COLUMN_COUNT);
        var3.size(CELL_COLUMN_COUNT);
        this.biomes = var3;
        int var4 = SectionPosition.sectionToBlockCoord(var02);
        int var5 = SectionPosition.sectionToBlockCoord(var1) - var4;
        this.areaWithOldGeneration = LevelHeightAccessor.create(var4, var5);
    }

    @Nullable
    public static BlendingData getOrUpdateBlendingData(RegionLimitedWorldAccess var0, int var1, int var2) {
        IChunkAccess var3 = var0.getChunk(var1, var2);
        BlendingData var4 = var3.getBlendingData();
        if (var4 == null) {
            return null;
        }
        var4.calculateData(var3, BlendingData.sideByGenerationAge(var0, var1, var2, false));
        return var4;
    }

    public static Set<EnumDirection8> sideByGenerationAge(GeneratorAccessSeed var0, int var1, int var2, boolean var3) {
        EnumSet<EnumDirection8> var4 = EnumSet.noneOf(EnumDirection8.class);
        for (EnumDirection8 var8 : EnumDirection8.values()) {
            int var10;
            int var9 = var1 + var8.getStepX();
            if (var0.getChunk(var9, var10 = var2 + var8.getStepZ()).isOldNoiseGeneration() != var3) continue;
            var4.add(var8);
        }
        return var4;
    }

    private void calculateData(IChunkAccess var0, Set<EnumDirection8> var1) {
        int var2;
        if (this.hasCalculatedData) {
            return;
        }
        if (var1.contains((Object)EnumDirection8.NORTH) || var1.contains((Object)EnumDirection8.WEST) || var1.contains((Object)EnumDirection8.NORTH_WEST)) {
            this.addValuesForColumn(BlendingData.getInsideIndex(0, 0), var0, 0, 0);
        }
        if (var1.contains((Object)EnumDirection8.NORTH)) {
            for (var2 = 1; var2 < QUARTS_PER_SECTION; ++var2) {
                this.addValuesForColumn(BlendingData.getInsideIndex(var2, 0), var0, 4 * var2, 0);
            }
        }
        if (var1.contains((Object)EnumDirection8.WEST)) {
            for (var2 = 1; var2 < QUARTS_PER_SECTION; ++var2) {
                this.addValuesForColumn(BlendingData.getInsideIndex(0, var2), var0, 0, 4 * var2);
            }
        }
        if (var1.contains((Object)EnumDirection8.EAST)) {
            for (var2 = 1; var2 < QUARTS_PER_SECTION; ++var2) {
                this.addValuesForColumn(BlendingData.getOutsideIndex(CELL_HORIZONTAL_MAX_INDEX_OUTSIDE, var2), var0, 15, 4 * var2);
            }
        }
        if (var1.contains((Object)EnumDirection8.SOUTH)) {
            for (var2 = 0; var2 < QUARTS_PER_SECTION; ++var2) {
                this.addValuesForColumn(BlendingData.getOutsideIndex(var2, CELL_HORIZONTAL_MAX_INDEX_OUTSIDE), var0, 4 * var2, 15);
            }
        }
        if (var1.contains((Object)EnumDirection8.EAST) && var1.contains((Object)EnumDirection8.NORTH_EAST)) {
            this.addValuesForColumn(BlendingData.getOutsideIndex(CELL_HORIZONTAL_MAX_INDEX_OUTSIDE, 0), var0, 15, 0);
        }
        if (var1.contains((Object)EnumDirection8.EAST) && var1.contains((Object)EnumDirection8.SOUTH) && var1.contains((Object)EnumDirection8.SOUTH_EAST)) {
            this.addValuesForColumn(BlendingData.getOutsideIndex(CELL_HORIZONTAL_MAX_INDEX_OUTSIDE, CELL_HORIZONTAL_MAX_INDEX_OUTSIDE), var0, 15, 15);
        }
        this.hasCalculatedData = true;
    }

    private void addValuesForColumn(int var0, IChunkAccess var1, int var2, int var3) {
        if (this.heights[var0] == Double.MAX_VALUE) {
            this.heights[var0] = this.getHeightAtXZ(var1, var2, var3);
        }
        this.densities[var0] = this.getDensityColumn(var1, var2, var3, MathHelper.floor(this.heights[var0]));
        this.biomes.set(var0, this.getBiomeColumn(var1, var2, var3));
    }

    private int getHeightAtXZ(IChunkAccess var0, int var1, int var2) {
        int var3 = var0.hasPrimedHeightmap(HeightMap.Type.WORLD_SURFACE_WG) ? Math.min(var0.getHeight(HeightMap.Type.WORLD_SURFACE_WG, var1, var2) + 1, this.areaWithOldGeneration.getMaxBuildHeight()) : this.areaWithOldGeneration.getMaxBuildHeight();
        int var4 = this.areaWithOldGeneration.getMinBuildHeight();
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition(var1, var3, var2);
        while (var5.getY() > var4) {
            var5.move(EnumDirection.DOWN);
            if (!SURFACE_BLOCKS.contains(var0.getBlockState(var5).getBlock())) continue;
            return var5.getY();
        }
        return var4;
    }

    private static double read1(IChunkAccess var0, BlockPosition.MutableBlockPosition var1) {
        return BlendingData.isGround(var0, var1.move(EnumDirection.DOWN)) ? 1.0 : -1.0;
    }

    private static double read7(IChunkAccess var0, BlockPosition.MutableBlockPosition var1) {
        double var2 = 0.0;
        for (int var4 = 0; var4 < 7; ++var4) {
            var2 += BlendingData.read1(var0, var1);
        }
        return var2;
    }

    private double[] getDensityColumn(IChunkAccess var0, int var1, int var2, int var3) {
        double var11;
        double var9;
        int var8;
        double[] var4 = new double[this.cellCountPerColumn()];
        Arrays.fill(var4, -1.0);
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition(var1, this.areaWithOldGeneration.getMaxBuildHeight(), var2);
        double var6 = BlendingData.read7(var0, var5);
        for (var8 = var4.length - 2; var8 >= 0; --var8) {
            var9 = BlendingData.read1(var0, var5);
            var11 = BlendingData.read7(var0, var5);
            var4[var8] = (var6 + var9 + var11) / 15.0;
            var6 = var11;
        }
        var8 = this.getCellYIndex(MathHelper.intFloorDiv(var3, 8));
        if (var8 >= 0 && var8 < var4.length - 1) {
            var9 = ((double)var3 + 0.5) % 8.0 / 8.0;
            var11 = (1.0 - var9) / var9;
            double var13 = Math.max(var11, 1.0) * 0.25;
            var4[var8 + 1] = -var11 / var13;
            var4[var8] = 1.0 / var13;
        }
        return var4;
    }

    private List<Holder<BiomeBase>> getBiomeColumn(IChunkAccess var0, int var1, int var2) {
        ObjectArrayList var3 = new ObjectArrayList(this.quartCountPerColumn());
        var3.size(this.quartCountPerColumn());
        for (int var4 = 0; var4 < var3.size(); ++var4) {
            int var5 = var4 + QuartPos.fromBlock(this.areaWithOldGeneration.getMinBuildHeight());
            var3.set(var4, var0.getNoiseBiome(QuartPos.fromBlock(var1), var5, QuartPos.fromBlock(var2)));
        }
        return var3;
    }

    private static boolean isGround(IChunkAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.isAir()) {
            return false;
        }
        if (var2.is(TagsBlock.LEAVES)) {
            return false;
        }
        if (var2.is(TagsBlock.LOGS)) {
            return false;
        }
        if (var2.is(Blocks.BROWN_MUSHROOM_BLOCK) || var2.is(Blocks.RED_MUSHROOM_BLOCK)) {
            return false;
        }
        return !var2.getCollisionShape(var0, var1).isEmpty();
    }

    protected double getHeight(int var0, int var1, int var2) {
        if (var0 == CELL_HORIZONTAL_MAX_INDEX_OUTSIDE || var2 == CELL_HORIZONTAL_MAX_INDEX_OUTSIDE) {
            return this.heights[BlendingData.getOutsideIndex(var0, var2)];
        }
        if (var0 == 0 || var2 == 0) {
            return this.heights[BlendingData.getInsideIndex(var0, var2)];
        }
        return Double.MAX_VALUE;
    }

    private double getDensity(@Nullable double[] var0, int var1) {
        if (var0 == null) {
            return Double.MAX_VALUE;
        }
        int var2 = this.getCellYIndex(var1);
        if (var2 < 0 || var2 >= var0.length) {
            return Double.MAX_VALUE;
        }
        return var0[var2] * 0.1;
    }

    protected double getDensity(int var0, int var1, int var2) {
        if (var1 == this.getMinY()) {
            return 0.1;
        }
        if (var0 == CELL_HORIZONTAL_MAX_INDEX_OUTSIDE || var2 == CELL_HORIZONTAL_MAX_INDEX_OUTSIDE) {
            return this.getDensity(this.densities[BlendingData.getOutsideIndex(var0, var2)], var1);
        }
        if (var0 == 0 || var2 == 0) {
            return this.getDensity(this.densities[BlendingData.getInsideIndex(var0, var2)], var1);
        }
        return Double.MAX_VALUE;
    }

    protected void iterateBiomes(int var0, int var1, int var2, a var3) {
        if (var1 < QuartPos.fromBlock(this.areaWithOldGeneration.getMinBuildHeight()) || var1 >= QuartPos.fromBlock(this.areaWithOldGeneration.getMaxBuildHeight())) {
            return;
        }
        int var4 = var1 - QuartPos.fromBlock(this.areaWithOldGeneration.getMinBuildHeight());
        for (int var5 = 0; var5 < this.biomes.size(); ++var5) {
            Holder<BiomeBase> var6;
            if (this.biomes.get(var5) == null || (var6 = this.biomes.get(var5).get(var4)) == null) continue;
            var3.consume(var0 + BlendingData.getX(var5), var2 + BlendingData.getZ(var5), var6);
        }
    }

    protected void iterateHeights(int var0, int var1, c var2) {
        for (int var3 = 0; var3 < this.heights.length; ++var3) {
            double var4 = this.heights[var3];
            if (var4 == Double.MAX_VALUE) continue;
            var2.consume(var0 + BlendingData.getX(var3), var1 + BlendingData.getZ(var3), var4);
        }
    }

    protected void iterateDensities(int var0, int var1, int var2, int var3, b var4) {
        int var5 = this.getColumnMinY();
        int var6 = Math.max(0, var2 - var5);
        int var7 = Math.min(this.cellCountPerColumn(), var3 - var5);
        for (int var8 = 0; var8 < this.densities.length; ++var8) {
            double[] var9 = this.densities[var8];
            if (var9 == null) continue;
            int var10 = var0 + BlendingData.getX(var8);
            int var11 = var1 + BlendingData.getZ(var8);
            for (int var12 = var6; var12 < var7; ++var12) {
                var4.consume(var10, var12 + var5, var11, var9[var12] * 0.1);
            }
        }
    }

    private int cellCountPerColumn() {
        return this.areaWithOldGeneration.getSectionsCount() * 2;
    }

    private int quartCountPerColumn() {
        return QuartPos.fromSection(this.areaWithOldGeneration.getSectionsCount());
    }

    private int getColumnMinY() {
        return this.getMinY() + 1;
    }

    private int getMinY() {
        return this.areaWithOldGeneration.getMinSection() * 2;
    }

    private int getCellYIndex(int var0) {
        return var0 - this.getColumnMinY();
    }

    private static int getInsideIndex(int var0, int var1) {
        return CELL_HORIZONTAL_MAX_INDEX_INSIDE - var0 + var1;
    }

    private static int getOutsideIndex(int var0, int var1) {
        return CELL_COLUMN_INSIDE_COUNT + var0 + CELL_HORIZONTAL_MAX_INDEX_OUTSIDE - var1;
    }

    private static int getX(int var0) {
        if (var0 < CELL_COLUMN_INSIDE_COUNT) {
            return BlendingData.zeroIfNegative(CELL_HORIZONTAL_MAX_INDEX_INSIDE - var0);
        }
        int var1 = var0 - CELL_COLUMN_INSIDE_COUNT;
        return CELL_HORIZONTAL_MAX_INDEX_OUTSIDE - BlendingData.zeroIfNegative(CELL_HORIZONTAL_MAX_INDEX_OUTSIDE - var1);
    }

    private static int getZ(int var0) {
        if (var0 < CELL_COLUMN_INSIDE_COUNT) {
            return BlendingData.zeroIfNegative(var0 - CELL_HORIZONTAL_MAX_INDEX_INSIDE);
        }
        int var1 = var0 - CELL_COLUMN_INSIDE_COUNT;
        return CELL_HORIZONTAL_MAX_INDEX_OUTSIDE - BlendingData.zeroIfNegative(var1 - CELL_HORIZONTAL_MAX_INDEX_OUTSIDE);
    }

    private static int zeroIfNegative(int var0) {
        return var0 & ~(var0 >> 31);
    }

    public LevelHeightAccessor getAreaWithOldGeneration() {
        return this.areaWithOldGeneration;
    }

    protected static interface a {
        public void consume(int var1, int var2, Holder<BiomeBase> var3);
    }

    protected static interface c {
        public void consume(int var1, int var2, double var3);
    }

    protected static interface b {
        public void consume(int var1, int var2, int var3, double var4);
    }
}

