/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import org.apache.commons.lang3.StringUtils;

public class GeneratorSettings {
    public static final Codec<GeneratorSettings> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(GeneratorSettings::seed), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(GeneratorSettings::generateStructures), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(GeneratorSettings::generateBonusChest), (App)RegistryCodecs.dataPackAwareCodec(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.stable(), WorldDimension.CODEC).xmap(WorldDimension::sortMap, Function.identity()).fieldOf("dimensions").forGetter(GeneratorSettings::dimensions), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(var0 -> var0.legacyCustomOptions)).apply((Applicative)var02, var02.stable(GeneratorSettings::new))).comapFlatMap(GeneratorSettings::guardExperimental, Function.identity());
    private final long seed;
    private final boolean generateStructures;
    private final boolean generateBonusChest;
    private final IRegistry<WorldDimension> dimensions;
    private final Optional<String> legacyCustomOptions;

    private DataResult<GeneratorSettings> guardExperimental() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.stable()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean stable() {
        return WorldDimension.stable(this.dimensions);
    }

    public GeneratorSettings(long var0, boolean var2, boolean var3, IRegistry<WorldDimension> var4) {
        this(var0, var2, var3, var4, Optional.empty());
        WorldDimension var5 = var4.get(WorldDimension.OVERWORLD);
        if (var5 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private GeneratorSettings(long var0, boolean var2, boolean var3, IRegistry<WorldDimension> var4, Optional<String> var5) {
        this.seed = var0;
        this.generateStructures = var2;
        this.generateBonusChest = var3;
        this.dimensions = var4;
        this.legacyCustomOptions = var5;
    }

    public long seed() {
        return this.seed;
    }

    public boolean generateStructures() {
        return this.generateStructures;
    }

    public boolean generateBonusChest() {
        return this.generateBonusChest;
    }

    public static GeneratorSettings replaceOverworldGenerator(IRegistryCustom var0, GeneratorSettings var1, ChunkGenerator var2) {
        IRegistry<DimensionManager> var3 = var0.registryOrThrow(IRegistry.DIMENSION_TYPE_REGISTRY);
        IRegistry<WorldDimension> var4 = GeneratorSettings.withOverworld(var3, var1.dimensions(), var2);
        return new GeneratorSettings(var1.seed(), var1.generateStructures(), var1.generateBonusChest(), var4);
    }

    public static IRegistry<WorldDimension> withOverworld(IRegistry<DimensionManager> var0, IRegistry<WorldDimension> var1, ChunkGenerator var2) {
        WorldDimension var3 = var1.get(WorldDimension.OVERWORLD);
        Holder<DimensionManager> var4 = var3 == null ? var0.getOrCreateHolderOrThrow(BuiltinDimensionTypes.OVERWORLD) : var3.typeHolder();
        return GeneratorSettings.withOverworld(var1, var4, var2);
    }

    public static IRegistry<WorldDimension> withOverworld(IRegistry<WorldDimension> var0, Holder<DimensionManager> var1, ChunkGenerator var2) {
        RegistryMaterials<WorldDimension> var3 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        ((IRegistryWritable)var3).register(WorldDimension.OVERWORLD, new WorldDimension(var1, var2), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var5 : var0.entrySet()) {
            ResourceKey<WorldDimension> var6 = var5.getKey();
            if (var6 == WorldDimension.OVERWORLD) continue;
            ((IRegistryWritable)var3).register(var6, var5.getValue(), var0.lifecycle(var5.getValue()));
        }
        return var3;
    }

    public IRegistry<WorldDimension> dimensions() {
        return this.dimensions;
    }

    public ChunkGenerator overworld() {
        WorldDimension var0 = this.dimensions.get(WorldDimension.OVERWORLD);
        if (var0 == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return var0.generator();
    }

    public ImmutableSet<ResourceKey<World>> levels() {
        return (ImmutableSet)this.dimensions().entrySet().stream().map(Map.Entry::getKey).map(GeneratorSettings::levelStemToLevel).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<World> levelStemToLevel(ResourceKey<WorldDimension> var0) {
        return ResourceKey.create(IRegistry.DIMENSION_REGISTRY, var0.location());
    }

    public static ResourceKey<WorldDimension> levelToLevelStem(ResourceKey<World> var0) {
        return ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, var0.location());
    }

    public boolean isDebug() {
        return this.overworld() instanceof ChunkProviderDebug;
    }

    public boolean isFlatWorld() {
        return this.overworld() instanceof ChunkProviderFlat;
    }

    public boolean isOldCustomizedWorld() {
        return this.legacyCustomOptions.isPresent();
    }

    public GeneratorSettings withBonusChest() {
        return new GeneratorSettings(this.seed, this.generateStructures, true, this.dimensions, this.legacyCustomOptions);
    }

    public GeneratorSettings withStructuresToggled() {
        return new GeneratorSettings(this.seed, !this.generateStructures, this.generateBonusChest, this.dimensions);
    }

    public GeneratorSettings withBonusChestToggled() {
        return new GeneratorSettings(this.seed, this.generateStructures, !this.generateBonusChest, this.dimensions);
    }

    public GeneratorSettings withSeed(boolean var0, OptionalLong var1) {
        IRegistry<WorldDimension> var5;
        long var3 = var1.orElse(this.seed);
        if (var1.isPresent()) {
            RegistryMaterials<WorldDimension> var6 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
            for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var8 : this.dimensions.entrySet()) {
                ResourceKey<WorldDimension> var9 = var8.getKey();
                ((IRegistryWritable)var6).register(var9, new WorldDimension(var8.getValue().typeHolder(), var8.getValue().generator()), this.dimensions.lifecycle(var8.getValue()));
            }
            var5 = var6;
        } else {
            var5 = this.dimensions;
        }
        GeneratorSettings var2 = this.isDebug() ? new GeneratorSettings(var3, false, false, var5) : new GeneratorSettings(var3, this.generateStructures(), this.generateBonusChest() && !var0, var5);
        return var2;
    }

    public static OptionalLong parseSeed(String var0) {
        if (StringUtils.isEmpty((CharSequence)(var0 = var0.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(var0));
        }
        catch (NumberFormatException var1) {
            return OptionalLong.of(var0.hashCode());
        }
    }
}

