/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class BlockPositionSource
implements PositionSource {
    public static final Codec<BlockPositionSource> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BlockPosition.CODEC.fieldOf("pos").forGetter(var0 -> var0.pos)).apply((Applicative)var02, BlockPositionSource::new));
    final BlockPosition pos;

    public BlockPositionSource(BlockPosition var0) {
        this.pos = var0;
    }

    @Override
    public Optional<Vec3D> getPosition(World var0) {
        return Optional.of(Vec3D.atCenterOf(this.pos));
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class a
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public BlockPositionSource read(PacketDataSerializer var0) {
            return new BlockPositionSource(var0.readBlockPos());
        }

        @Override
        public void write(PacketDataSerializer var0, BlockPositionSource var1) {
            var0.writeBlockPos(var1.pos);
        }

        @Override
        public Codec<BlockPositionSource> codec() {
            return CODEC;
        }

        @Override
        public /* synthetic */ PositionSource read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    }
}

