/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;

public final class WorldDimension {
    public static final Codec<WorldDimension> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)DimensionManager.CODEC.fieldOf("type").forGetter(WorldDimension::typeHolder), (App)ChunkGenerator.CODEC.fieldOf("generator").forGetter(WorldDimension::generator)).apply((Applicative)var0, var0.stable(WorldDimension::new)));
    public static final ResourceKey<WorldDimension> OVERWORLD = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("overworld"));
    public static final ResourceKey<WorldDimension> NETHER = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_nether"));
    public static final ResourceKey<WorldDimension> END = ResourceKey.create(IRegistry.LEVEL_STEM_REGISTRY, new MinecraftKey("the_end"));
    private static final Set<ResourceKey<WorldDimension>> BUILTIN_ORDER = ImmutableSet.of(OVERWORLD, NETHER, END);
    private final Holder<DimensionManager> type;
    private final ChunkGenerator generator;

    public WorldDimension(Holder<DimensionManager> var0, ChunkGenerator var1) {
        this.type = var0;
        this.generator = var1;
    }

    public Holder<DimensionManager> typeHolder() {
        return this.type;
    }

    public ChunkGenerator generator() {
        return this.generator;
    }

    public static Stream<ResourceKey<WorldDimension>> keysInOrder(Stream<ResourceKey<WorldDimension>> var02) {
        return Stream.concat(BUILTIN_ORDER.stream(), var02.filter(var0 -> !BUILTIN_ORDER.contains(var0)));
    }

    public static IRegistry<WorldDimension> sortMap(IRegistry<WorldDimension> var0) {
        RegistryMaterials<WorldDimension> var1 = new RegistryMaterials<WorldDimension>(IRegistry.LEVEL_STEM_REGISTRY, Lifecycle.experimental(), null);
        WorldDimension.keysInOrder(var0.registryKeySet().stream()).forEach(var2 -> {
            WorldDimension var3 = (WorldDimension)var0.get((ResourceKey<WorldDimension>)var2);
            if (var3 != null) {
                var1.register((ResourceKey<WorldDimension>)var2, var3, var0.lifecycle(var3));
            }
        });
        return var1;
    }

    public static boolean stable(IRegistry<WorldDimension> var0) {
        if (var0.size() != BUILTIN_ORDER.size()) {
            return false;
        }
        Optional<WorldDimension> var1 = var0.getOptional(OVERWORLD);
        Optional<WorldDimension> var2 = var0.getOptional(NETHER);
        Optional<WorldDimension> var3 = var0.getOptional(END);
        if (var1.isEmpty() || var2.isEmpty() || var3.isEmpty()) {
            return false;
        }
        if (!var1.get().typeHolder().is(BuiltinDimensionTypes.OVERWORLD) && !var1.get().typeHolder().is(BuiltinDimensionTypes.OVERWORLD_CAVES)) {
            return false;
        }
        if (!var2.get().typeHolder().is(BuiltinDimensionTypes.NETHER)) {
            return false;
        }
        if (!var3.get().typeHolder().is(BuiltinDimensionTypes.END)) {
            return false;
        }
        if (!(var2.get().generator() instanceof ChunkGeneratorAbstract) || !(var3.get().generator() instanceof ChunkGeneratorAbstract)) {
            return false;
        }
        ChunkGeneratorAbstract var4 = (ChunkGeneratorAbstract)var2.get().generator();
        ChunkGeneratorAbstract var5 = (ChunkGeneratorAbstract)var3.get().generator();
        if (!var4.stable(GeneratorSettingBase.NETHER)) {
            return false;
        }
        if (!var5.stable(GeneratorSettingBase.END)) {
            return false;
        }
        if (!(var4.getBiomeSource() instanceof WorldChunkManagerMultiNoise)) {
            return false;
        }
        WorldChunkManagerMultiNoise var6 = (WorldChunkManagerMultiNoise)var4.getBiomeSource();
        if (!var6.stable(WorldChunkManagerMultiNoise.a.NETHER)) {
            return false;
        }
        WorldChunkManager var7 = var1.get().generator().getBiomeSource();
        if (var7 instanceof WorldChunkManagerMultiNoise && !((WorldChunkManagerMultiNoise)var7).stable(WorldChunkManagerMultiNoise.a.OVERWORLD)) {
            return false;
        }
        return var5.getBiomeSource() instanceof WorldChunkManagerTheEnd;
    }
}

