/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.PairedQueue;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final ThreadedMailbox<PairedQueue.b> mailbox;
    private final RegionFileCache storage;
    private final Map<ChunkCoordIntPair, a> pendingWrites = Maps.newLinkedHashMap();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> regionCacheForBlender = new Long2ObjectLinkedOpenHashMap();
    private static final int REGION_CACHE_SIZE = 1024;

    protected IOWorker(Path var0, boolean var1, String var2) {
        this.storage = new RegionFileCache(var0, var1);
        this.mailbox = new ThreadedMailbox<PairedQueue.b>(new PairedQueue.a(Priority.values().length), SystemUtils.ioPool(), "IOWorker-" + var2);
    }

    public boolean isOldChunkAround(ChunkCoordIntPair var0, int var1) {
        ChunkCoordIntPair var2 = new ChunkCoordIntPair(var0.x - var1, var0.z - var1);
        ChunkCoordIntPair var3 = new ChunkCoordIntPair(var0.x + var1, var0.z + var1);
        for (int var4 = var2.getRegionX(); var4 <= var3.getRegionX(); ++var4) {
            for (int var5 = var2.getRegionZ(); var5 <= var3.getRegionZ(); ++var5) {
                BitSet var6 = this.getOrCreateOldDataForRegion(var4, var5).join();
                if (var6.isEmpty()) continue;
                ChunkCoordIntPair var7 = ChunkCoordIntPair.minFromRegion(var4, var5);
                int var8 = Math.max(var2.x - var7.x, 0);
                int var9 = Math.max(var2.z - var7.z, 0);
                int var10 = Math.min(var3.x - var7.x, 31);
                int var11 = Math.min(var3.z - var7.z, 31);
                for (int var12 = var8; var12 <= var10; ++var12) {
                    for (int var13 = var9; var13 <= var11; ++var13) {
                        int var14 = var13 * 32 + var12;
                        if (!var6.get(var14)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> getOrCreateOldDataForRegion(int var0, int var1) {
        long var2 = ChunkCoordIntPair.asLong(var0, var1);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.regionCacheForBlender;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> var5 = (CompletableFuture<BitSet>)this.regionCacheForBlender.getAndMoveToFirst(var2);
            if (var5 == null) {
                var5 = this.createOldDataForRegion(var0, var1);
                this.regionCacheForBlender.putAndMoveToFirst(var2, var5);
                if (this.regionCacheForBlender.size() > 1024) {
                    this.regionCacheForBlender.removeLast();
                }
            }
            return var5;
        }
    }

    private CompletableFuture<BitSet> createOldDataForRegion(int var0, int var1) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkCoordIntPair var2 = ChunkCoordIntPair.minFromRegion(var0, var1);
            ChunkCoordIntPair var3 = ChunkCoordIntPair.maxFromRegion(var0, var1);
            BitSet var4 = new BitSet();
            ChunkCoordIntPair.rangeClosed(var2, var3).forEach(var1 -> {
                NBTTagCompound var4;
                CollectFields var2 = new CollectFields(new FieldSelector(NBTTagInt.TYPE, "DataVersion"), new FieldSelector(NBTTagCompound.TYPE, "blending_data"));
                try {
                    this.scanChunk((ChunkCoordIntPair)var1, var2).join();
                }
                catch (Exception var3) {
                    LOGGER.warn("Failed to scan chunk {}", var1, (Object)var3);
                    return;
                }
                NBTBase var3 = var2.getResult();
                if (var3 instanceof NBTTagCompound && this.isOldChunk(var4 = (NBTTagCompound)var3)) {
                    int var5 = var1.getRegionLocalZ() * 32 + var1.getRegionLocalX();
                    var4.set(var5);
                }
            });
            return var4;
        }, SystemUtils.backgroundExecutor());
    }

    private boolean isOldChunk(NBTTagCompound var0) {
        if (!var0.contains("DataVersion", 99) || var0.getInt("DataVersion") < 3088) {
            return true;
        }
        return var0.contains("blending_data", 10);
    }

    public CompletableFuture<Void> store(ChunkCoordIntPair var0, @Nullable NBTTagCompound var1) {
        return this.submitTask(() -> {
            a var2 = this.pendingWrites.computeIfAbsent(var0, var1 -> new a(var1));
            var2.data = var1;
            return Either.left(var2.result);
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<NBTTagCompound>> loadAsync(ChunkCoordIntPair var0) {
        return this.submitTask(() -> {
            a var1 = this.pendingWrites.get(var0);
            if (var1 != null) {
                return Either.left(Optional.ofNullable(var1.data));
            }
            try {
                NBTTagCompound var2 = this.storage.read(var0);
                return Either.left(Optional.ofNullable(var2));
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to read chunk {}", (Object)var0, (Object)var2);
                return Either.right((Object)var2);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean var02) {
        CompletionStage var1 = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(var0 -> var0.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        if (var02) {
            return ((CompletableFuture)var1).thenCompose(var0 -> this.submitTask(() -> {
                try {
                    this.storage.flush();
                    return Either.left(null);
                }
                catch (Exception var0) {
                    LOGGER.warn("Failed to synchronize chunks", (Throwable)var0);
                    return Either.right((Object)var0);
                }
            }));
        }
        return ((CompletableFuture)var1).thenCompose(var0 -> this.submitTask(() -> Either.left(null)));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkCoordIntPair var0, StreamTagVisitor var1) {
        return this.submitTask(() -> {
            try {
                a var2 = this.pendingWrites.get(var0);
                if (var2 != null) {
                    if (var2.data != null) {
                        var2.data.acceptAsRoot(var1);
                    }
                } else {
                    this.storage.scanChunk(var0, var1);
                }
                return Either.left(null);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)var0, (Object)var2);
                return Either.right((Object)var2);
            }
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> var0) {
        return this.mailbox.askEither(var1 -> new PairedQueue.b(Priority.FOREGROUND.ordinal(), () -> this.a(var1, (Supplier)var0)));
    }

    private void storePendingChunk() {
        if (this.pendingWrites.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ChunkCoordIntPair, a>> var0 = this.pendingWrites.entrySet().iterator();
        Map.Entry<ChunkCoordIntPair, a> var1 = var0.next();
        var0.remove();
        this.runStore(var1.getKey(), var1.getValue());
        this.tellStorePending();
    }

    private void tellStorePending() {
        this.mailbox.tell(new PairedQueue.b(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkCoordIntPair var0, a var1) {
        try {
            this.storage.write(var0, var1.data);
            var1.result.complete(null);
        }
        catch (Exception var2) {
            LOGGER.error("Failed to store chunk {}", (Object)var0, (Object)var2);
            var1.result.completeExceptionally(var2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        this.mailbox.ask(var0 -> new PairedQueue.b(Priority.SHUTDOWN.ordinal(), () -> var0.tell(Unit.INSTANCE))).join();
        this.mailbox.close();
        try {
            this.storage.close();
        }
        catch (Exception var02) {
            LOGGER.error("Failed to close storage", (Throwable)var02);
        }
    }

    private /* synthetic */ void a(Mailbox var0, Supplier var1) {
        if (!this.shutdownRequested.get()) {
            var0.tell((Either)var1.get());
        }
        this.tellStorePending();
    }

    static final class Priority
    extends Enum<Priority> {
        public static final /* enum */ Priority FOREGROUND = new Priority();
        public static final /* enum */ Priority BACKGROUND = new Priority();
        public static final /* enum */ Priority SHUTDOWN = new Priority();
        private static final /* synthetic */ Priority[] d;

        public static Priority[] values() {
            return (Priority[])d.clone();
        }

        public static Priority valueOf(String var0) {
            return Enum.valueOf(Priority.class, var0);
        }

        private static /* synthetic */ Priority[] a() {
            return new Priority[]{FOREGROUND, BACKGROUND, SHUTDOWN};
        }

        static {
            d = Priority.a();
        }
    }

    static class a {
        @Nullable
        NBTTagCompound data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public a(@Nullable NBTTagCompound var0) {
            this.data = var0;
        }
    }
}

