/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.lighting.LightEngine;

public abstract class IChunkProvider
implements ILightAccess,
AutoCloseable {
    @Nullable
    public Chunk getChunk(int var0, int var1, boolean var2) {
        return (Chunk)this.getChunk(var0, var1, ChunkStatus.FULL, var2);
    }

    @Nullable
    public Chunk getChunkNow(int var0, int var1) {
        return this.getChunk(var0, var1, false);
    }

    @Override
    @Nullable
    public IBlockAccess getChunkForLighting(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.EMPTY, false);
    }

    public boolean hasChunk(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, false) != null;
    }

    @Nullable
    public abstract IChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    public abstract void tick(BooleanSupplier var1, boolean var2);

    public abstract String gatherStats();

    public abstract int getLoadedChunksCount();

    @Override
    public void close() throws IOException {
    }

    public abstract LightEngine getLightEngine();

    public void setSpawnSettings(boolean var0, boolean var1) {
    }

    public void updateChunkForced(ChunkCoordIntPair var0, boolean var1) {
    }
}

