/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements IBlockAccess,
BiomeManager.Provider,
StructureAccess {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LongSet EMPTY_REFERENCE_SET = new LongOpenHashSet();
    protected final ShortList[] postProcessing;
    protected volatile boolean unsaved;
    private volatile boolean isLightCorrect;
    protected final ChunkCoordIntPair chunkPos;
    private long inhabitedTime;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration carverBiomeSettings;
    @Nullable
    protected NoiseChunk noiseChunk;
    protected final ChunkConverter upgradeData;
    @Nullable
    protected BlendingData blendingData;
    public final Map<HeightMap.Type, HeightMap> heightmaps = Maps.newEnumMap(HeightMap.Type.class);
    private final Map<Structure, StructureStart> structureStarts = Maps.newHashMap();
    private final Map<Structure, LongSet> structuresRefences = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> pendingBlockEntities = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> blockEntities = Maps.newHashMap();
    protected final LevelHeightAccessor levelHeightAccessor;
    protected final ChunkSection[] sections;

    public IChunkAccess(ChunkCoordIntPair var0, ChunkConverter var1, LevelHeightAccessor var2, IRegistry<BiomeBase> var3, long var4, @Nullable ChunkSection[] var6, @Nullable BlendingData var7) {
        this.chunkPos = var0;
        this.upgradeData = var1;
        this.levelHeightAccessor = var2;
        this.sections = new ChunkSection[var2.getSectionsCount()];
        this.inhabitedTime = var4;
        this.postProcessing = new ShortList[var2.getSectionsCount()];
        this.blendingData = var7;
        if (var6 != null) {
            if (this.sections.length == var6.length) {
                System.arraycopy(var6, 0, this.sections, 0, this.sections.length);
            } else {
                LOGGER.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)var6.length, (Object)this.sections.length);
            }
        }
        IChunkAccess.replaceMissingSections(var2, var3, this.sections);
    }

    private static void replaceMissingSections(LevelHeightAccessor var0, IRegistry<BiomeBase> var1, ChunkSection[] var2) {
        for (int var3 = 0; var3 < var2.length; ++var3) {
            if (var2[var3] != null) continue;
            var2[var3] = new ChunkSection(var0.getSectionYFromSectionIndex(var3), var1);
        }
    }

    public GameEventDispatcher getEventDispatcher(int var0) {
        return GameEventDispatcher.NOOP;
    }

    @Nullable
    public abstract IBlockData setBlockState(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void setBlockEntity(TileEntity var1);

    public abstract void addEntity(Entity var1);

    @Nullable
    public ChunkSection getHighestSection() {
        ChunkSection[] var0 = this.getSections();
        for (int var1 = var0.length - 1; var1 >= 0; --var1) {
            ChunkSection var2 = var0[var1];
            if (var2.hasOnlyAir()) continue;
            return var2;
        }
        return null;
    }

    public int getHighestSectionPosition() {
        ChunkSection var0 = this.getHighestSection();
        return var0 == null ? this.getMinBuildHeight() : var0.bottomBlockY();
    }

    public Set<BlockPosition> getBlockEntitiesPos() {
        HashSet var0 = Sets.newHashSet(this.pendingBlockEntities.keySet());
        var0.addAll(this.blockEntities.keySet());
        return var0;
    }

    public ChunkSection[] getSections() {
        return this.sections;
    }

    public ChunkSection getSection(int var0) {
        return this.getSections()[var0];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> getHeightmaps() {
        return Collections.unmodifiableSet(this.heightmaps.entrySet());
    }

    public void setHeightmap(HeightMap.Type var0, long[] var1) {
        this.getOrCreateHeightmapUnprimed(var0).setRawData(this, var0, var1);
    }

    public HeightMap getOrCreateHeightmapUnprimed(HeightMap.Type var02) {
        return this.heightmaps.computeIfAbsent(var02, var0 -> new HeightMap(this, (HeightMap.Type)var0));
    }

    public boolean hasPrimedHeightmap(HeightMap.Type var0) {
        return this.heightmaps.get(var0) != null;
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        HeightMap var3 = this.heightmaps.get(var0);
        if (var3 == null) {
            if (SharedConstants.IS_RUNNING_IN_IDE && this instanceof Chunk) {
                LOGGER.error("Unprimed heightmap: " + var0 + " " + var1 + " " + var2);
            }
            HeightMap.primeHeightmaps(this, EnumSet.of(var0));
            var3 = this.heightmaps.get(var0);
        }
        return var3.getFirstAvailable(var1 & 0xF, var2 & 0xF) - 1;
    }

    public ChunkCoordIntPair getPos() {
        return this.chunkPos;
    }

    @Override
    @Nullable
    public StructureStart getStartForStructure(Structure var0) {
        return this.structureStarts.get(var0);
    }

    @Override
    public void setStartForStructure(Structure var0, StructureStart var1) {
        this.structureStarts.put(var0, var1);
        this.unsaved = true;
    }

    public Map<Structure, StructureStart> getAllStarts() {
        return Collections.unmodifiableMap(this.structureStarts);
    }

    public void setAllStarts(Map<Structure, StructureStart> var0) {
        this.structureStarts.clear();
        this.structureStarts.putAll(var0);
        this.unsaved = true;
    }

    @Override
    public LongSet getReferencesForStructure(Structure var0) {
        return this.structuresRefences.getOrDefault(var0, EMPTY_REFERENCE_SET);
    }

    @Override
    public void addReferenceForStructure(Structure var02, long var1) {
        this.structuresRefences.computeIfAbsent(var02, var0 -> new LongOpenHashSet()).add(var1);
        this.unsaved = true;
    }

    @Override
    public Map<Structure, LongSet> getAllReferences() {
        return Collections.unmodifiableMap(this.structuresRefences);
    }

    @Override
    public void setAllReferences(Map<Structure, LongSet> var0) {
        this.structuresRefences.clear();
        this.structuresRefences.putAll(var0);
        this.unsaved = true;
    }

    public boolean isYSpaceEmpty(int var0, int var1) {
        if (var0 < this.getMinBuildHeight()) {
            var0 = this.getMinBuildHeight();
        }
        if (var1 >= this.getMaxBuildHeight()) {
            var1 = this.getMaxBuildHeight() - 1;
        }
        for (int var2 = var0; var2 <= var1; var2 += 16) {
            if (this.getSection(this.getSectionIndex(var2)).hasOnlyAir()) continue;
            return false;
        }
        return true;
    }

    public void setUnsaved(boolean var0) {
        this.unsaved = var0;
    }

    public boolean isUnsaved() {
        return this.unsaved;
    }

    public abstract ChunkStatus getStatus();

    public abstract void removeBlockEntity(BlockPosition var1);

    public void markPosForPostprocessing(BlockPosition var0) {
        LOGGER.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)var0);
    }

    public ShortList[] getPostProcessing() {
        return this.postProcessing;
    }

    public void addPackedPostProcess(short var0, int var1) {
        IChunkAccess.getOrCreateOffsetList(this.getPostProcessing(), var1).add(var0);
    }

    public void setBlockEntityNbt(NBTTagCompound var0) {
        this.pendingBlockEntities.put(TileEntity.getPosFromTag(var0), var0);
    }

    @Nullable
    public NBTTagCompound getBlockEntityNbt(BlockPosition var0) {
        return this.pendingBlockEntities.get(var0);
    }

    @Nullable
    public abstract NBTTagCompound getBlockEntityNbtForSaving(BlockPosition var1);

    public abstract Stream<BlockPosition> getLights();

    public abstract TickContainerAccess<Block> getBlockTicks();

    public abstract TickContainerAccess<FluidType> getFluidTicks();

    public abstract a getTicksForSerialization();

    public ChunkConverter getUpgradeData() {
        return this.upgradeData;
    }

    public boolean isOldNoiseGeneration() {
        return this.blendingData != null;
    }

    @Nullable
    public BlendingData getBlendingData() {
        return this.blendingData;
    }

    public void setBlendingData(BlendingData var0) {
        this.blendingData = var0;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public void incrementInhabitedTime(long var0) {
        this.inhabitedTime += var0;
    }

    public void setInhabitedTime(long var0) {
        this.inhabitedTime = var0;
    }

    public static ShortList getOrCreateOffsetList(ShortList[] var0, int var1) {
        if (var0[var1] == null) {
            var0[var1] = new ShortArrayList();
        }
        return var0[var1];
    }

    public boolean isLightCorrect() {
        return this.isLightCorrect;
    }

    public void setLightCorrect(boolean var0) {
        this.isLightCorrect = var0;
        this.setUnsaved(true);
    }

    @Override
    public int getMinBuildHeight() {
        return this.levelHeightAccessor.getMinBuildHeight();
    }

    @Override
    public int getHeight() {
        return this.levelHeightAccessor.getHeight();
    }

    public NoiseChunk getOrCreateNoiseChunk(Function<IChunkAccess, NoiseChunk> var0) {
        if (this.noiseChunk == null) {
            this.noiseChunk = var0.apply(this);
        }
        return this.noiseChunk;
    }

    @Deprecated
    public BiomeSettingsGeneration carverBiome(Supplier<BiomeSettingsGeneration> var0) {
        if (this.carverBiomeSettings == null) {
            this.carverBiomeSettings = var0.get();
        }
        return this.carverBiomeSettings;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int var0, int var1, int var2) {
        try {
            int var3 = QuartPos.fromBlock(this.getMinBuildHeight());
            int var4 = var3 + QuartPos.fromBlock(this.getHeight()) - 1;
            int var5 = MathHelper.clamp(var1, var3, var4);
            int var6 = this.getSectionIndex(QuartPos.toBlock(var5));
            return this.sections[var6].getNoiseBiome(var0 & 3, var5 & 3, var2 & 3);
        }
        catch (Throwable var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Getting biome");
            CrashReportSystemDetails var5 = var4.addCategory("Biome being got");
            var5.setDetail("Location", () -> CrashReportSystemDetails.formatLocation((LevelHeightAccessor)this, var0, var1, var2));
            throw new ReportedException(var4);
        }
    }

    public void fillBiomesFromNoise(BiomeResolver var0, Climate.Sampler var1) {
        ChunkCoordIntPair var2 = this.getPos();
        int var3 = QuartPos.fromBlock(var2.getMinBlockX());
        int var4 = QuartPos.fromBlock(var2.getMinBlockZ());
        LevelHeightAccessor var5 = this.getHeightAccessorForGeneration();
        for (int var6 = var5.getMinSection(); var6 < var5.getMaxSection(); ++var6) {
            ChunkSection var7 = this.getSection(this.getSectionIndexFromSectionY(var6));
            var7.fillBiomesFromNoise(var0, var1, var3, var4);
        }
    }

    public boolean hasAnyStructureReferences() {
        return !this.getAllReferences().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen getBelowZeroRetrogen() {
        return null;
    }

    public boolean isUpgrading() {
        return this.getBelowZeroRetrogen() != null;
    }

    public LevelHeightAccessor getHeightAccessorForGeneration() {
        return this;
    }

    public record a(SerializableTickContainer<Block> blocks, SerializableTickContainer<FluidType> fluids) {
    }
}

