/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class TileEntityJukeBox
extends TileEntity
implements Clearable {
    private ItemStack record = ItemStack.EMPTY;
    private int ticksSinceLastEvent;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;

    public TileEntityJukeBox(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.JUKEBOX, var0, var1);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        if (var0.contains("RecordItem", 10)) {
            this.setRecord(ItemStack.of(var0.getCompound("RecordItem")));
        }
        this.isPlaying = var0.getBoolean("IsPlaying");
        this.recordStartedTick = var0.getLong("RecordStartTick");
        this.tickCount = var0.getLong("TickCount");
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (!this.getRecord().isEmpty()) {
            var0.put("RecordItem", this.getRecord().save(new NBTTagCompound()));
        }
        var0.putBoolean("IsPlaying", this.isPlaying);
        var0.putLong("RecordStartTick", this.recordStartedTick);
        var0.putLong("TickCount", this.tickCount);
    }

    public ItemStack getRecord() {
        return this.record;
    }

    public void setRecord(ItemStack var0) {
        this.record = var0;
        this.setChanged();
    }

    public void playRecord() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
    }

    @Override
    public void clearContent() {
        this.setRecord(ItemStack.EMPTY);
        this.isPlaying = false;
    }

    public static void playRecordTick(World var0, BlockPosition var1, IBlockData var2, TileEntityJukeBox var3) {
        Item item;
        ++var3.ticksSinceLastEvent;
        if (TileEntityJukeBox.recordIsPlaying(var2, var3) && (item = var3.getRecord().getItem()) instanceof ItemRecord) {
            ItemRecord var4 = (ItemRecord)item;
            if (TileEntityJukeBox.recordShouldStopPlaying(var3, var4)) {
                var0.gameEvent(GameEvent.JUKEBOX_STOP_PLAY, var1, GameEvent.a.of(var2));
                var3.isPlaying = false;
            } else if (TileEntityJukeBox.shouldSendJukeboxPlayingEvent(var3)) {
                var3.ticksSinceLastEvent = 0;
                var0.gameEvent(GameEvent.JUKEBOX_PLAY, var1, GameEvent.a.of(var2));
            }
        }
        ++var3.tickCount;
    }

    private static boolean recordIsPlaying(IBlockData var0, TileEntityJukeBox var1) {
        return var0.getValue(BlockJukeBox.HAS_RECORD) != false && var1.isPlaying;
    }

    private static boolean recordShouldStopPlaying(TileEntityJukeBox var0, ItemRecord var1) {
        return var0.tickCount >= var0.recordStartedTick + (long)var1.getLengthInTicks();
    }

    private static boolean shouldSendJukeboxPlayingEvent(TileEntityJukeBox var0) {
        return var0.ticksSinceLastEvent >= 20;
    }
}

