/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityEnderChest
extends TileEntity
implements LidBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    public final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        @Override
        protected void onOpen(World var0, BlockPosition var1, IBlockData var2) {
            var0.playSound(null, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEffects.ENDER_CHEST_OPEN, SoundCategory.BLOCKS, 0.5f, var0.random.nextFloat() * 0.1f + 0.9f);
        }

        @Override
        protected void onClose(World var0, BlockPosition var1, IBlockData var2) {
            var0.playSound(null, (double)var1.getX() + 0.5, (double)var1.getY() + 0.5, (double)var1.getZ() + 0.5, SoundEffects.ENDER_CHEST_CLOSE, SoundCategory.BLOCKS, 0.5f, var0.random.nextFloat() * 0.1f + 0.9f);
        }

        @Override
        protected void openerCountChanged(World var0, BlockPosition var1, IBlockData var2, int var3, int var4) {
            var0.blockEvent(TileEntityEnderChest.this.worldPosition, Blocks.ENDER_CHEST, 1, var4);
        }

        @Override
        protected boolean isOwnContainer(EntityHuman var0) {
            return var0.getEnderChestInventory().isActiveChest(TileEntityEnderChest.this);
        }
    };

    public TileEntityEnderChest(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.ENDER_CHEST, var0, var1);
    }

    public static void lidAnimateTick(World var0, BlockPosition var1, IBlockData var2, TileEntityEnderChest var3) {
        var3.chestLidController.tickLid();
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (var0 == 1) {
            this.chestLidController.shouldBeOpen(var1 > 0);
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    public void startOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.incrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(EntityHuman var0) {
        if (!this.remove && !var0.isSpectator()) {
            this.openersCounter.decrementOpeners(var0, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public boolean stillValid(EntityHuman var0) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(var0.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @Override
    public float getOpenNess(float var0) {
        return this.chestLidController.getOpenness(var0);
    }
}

