/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerBrewingStand;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityBrewingStand
extends TileEntityContainer
implements IWorldInventory {
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    public static final int FUEL_USES = 20;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int NUM_DATA_VALUES = 2;
    private NonNullList<ItemStack> items = NonNullList.withSize(5, ItemStack.EMPTY);
    public int brewTime;
    private boolean[] lastPotionCount;
    private Item ingredient;
    public int fuel;
    protected final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            switch (var0) {
                case 0: {
                    return TileEntityBrewingStand.this.brewTime;
                }
                case 1: {
                    return TileEntityBrewingStand.this.fuel;
                }
            }
            return 0;
        }

        @Override
        public void set(int var0, int var1) {
            switch (var0) {
                case 0: {
                    TileEntityBrewingStand.this.brewTime = var1;
                    break;
                }
                case 1: {
                    TileEntityBrewingStand.this.fuel = var1;
                }
            }
        }

        @Override
        public int getCount() {
            return 2;
        }
    };

    public TileEntityBrewingStand(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.BREWING_STAND, var0, var1);
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return IChatBaseComponent.translatable("container.brewing");
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack var1 : this.items) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, TileEntityBrewingStand var3) {
        ItemStack var4 = var3.items.get(4);
        if (var3.fuel <= 0 && var4.is(Items.BLAZE_POWDER)) {
            var3.fuel = 20;
            var4.shrink(1);
            TileEntityBrewingStand.setChanged(var0, var1, var2);
        }
        boolean var5 = TileEntityBrewingStand.isBrewable(var3.items);
        boolean var6 = var3.brewTime > 0;
        ItemStack var7 = var3.items.get(3);
        if (var6) {
            boolean var8;
            --var3.brewTime;
            boolean bl = var8 = var3.brewTime == 0;
            if (var8 && var5) {
                TileEntityBrewingStand.doBrew(var0, var1, var3.items);
                TileEntityBrewingStand.setChanged(var0, var1, var2);
            } else if (!var5 || !var7.is(var3.ingredient)) {
                var3.brewTime = 0;
                TileEntityBrewingStand.setChanged(var0, var1, var2);
            }
        } else if (var5 && var3.fuel > 0) {
            --var3.fuel;
            var3.brewTime = 400;
            var3.ingredient = var7.getItem();
            TileEntityBrewingStand.setChanged(var0, var1, var2);
        }
        boolean[] var8 = var3.getPotionBits();
        if (!Arrays.equals(var8, var3.lastPotionCount)) {
            var3.lastPotionCount = var8;
            IBlockData var9 = var2;
            if (!(var9.getBlock() instanceof BlockBrewingStand)) {
                return;
            }
            for (int var10 = 0; var10 < BlockBrewingStand.HAS_BOTTLE.length; ++var10) {
                var9 = (IBlockData)var9.setValue(BlockBrewingStand.HAS_BOTTLE[var10], var8[var10]);
            }
            var0.setBlock(var1, var9, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] var0 = new boolean[3];
        for (int var1 = 0; var1 < 3; ++var1) {
            if (this.items.get(var1).isEmpty()) continue;
            var0[var1] = true;
        }
        return var0;
    }

    private static boolean isBrewable(NonNullList<ItemStack> var0) {
        ItemStack var1 = var0.get(3);
        if (var1.isEmpty()) {
            return false;
        }
        if (!PotionBrewer.isIngredient(var1)) {
            return false;
        }
        for (int var2 = 0; var2 < 3; ++var2) {
            ItemStack var3 = var0.get(var2);
            if (var3.isEmpty() || !PotionBrewer.hasMix(var3, var1)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(World var0, BlockPosition var1, NonNullList<ItemStack> var2) {
        ItemStack var3 = var2.get(3);
        for (int var4 = 0; var4 < 3; ++var4) {
            var2.set(var4, PotionBrewer.mix(var3, var2.get(var4)));
        }
        var3.shrink(1);
        if (var3.getItem().hasCraftingRemainingItem()) {
            ItemStack var4 = new ItemStack(var3.getItem().getCraftingRemainingItem());
            if (var3.isEmpty()) {
                var3 = var4;
            } else {
                InventoryUtils.dropItemStack(var0, var1.getX(), var1.getY(), var1.getZ(), var4);
            }
        }
        var2.set(3, var3);
        var0.levelEvent(1035, var1, 0);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerUtil.loadAllItems(var0, this.items);
        this.brewTime = var0.getShort("BrewTime");
        this.fuel = var0.getByte("Fuel");
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        var0.putShort("BrewTime", (short)this.brewTime);
        ContainerUtil.saveAllItems(var0, this.items);
        var0.putByte("Fuel", (byte)this.fuel);
    }

    @Override
    public ItemStack getItem(int var0) {
        if (var0 >= 0 && var0 < this.items.size()) {
            return this.items.get(var0);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        return ContainerUtil.removeItem(this.items, var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return ContainerUtil.takeItem(this.items, var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        if (var0 >= 0 && var0 < this.items.size()) {
            this.items.set(var0, var1);
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(var0.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (var0 == 3) {
            return PotionBrewer.isIngredient(var1);
        }
        if (var0 == 4) {
            return var1.is(Items.BLAZE_POWDER);
        }
        return (var1.is(Items.POTION) || var1.is(Items.SPLASH_POTION) || var1.is(Items.LINGERING_POTION) || var1.is(Items.GLASS_BOTTLE)) && this.getItem(var0).isEmpty();
    }

    @Override
    public int[] getSlotsForFace(EnumDirection var0) {
        if (var0 == EnumDirection.UP) {
            return SLOTS_FOR_UP;
        }
        if (var0 == EnumDirection.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
        return this.canPlaceItem(var0, var1);
    }

    @Override
    public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
        if (var0 == 3) {
            return var1.is(Items.GLASS_BOTTLE);
        }
        return true;
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerBrewingStand(var0, var1, this, this.dataAccess);
    }
}

