/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;

public class SculkCatalystBlockEntity
extends TileEntity
implements GameEventListener {
    private final BlockPositionSource blockPosSource;
    private final SculkSpreader sculkSpreader;

    public SculkCatalystBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SCULK_CATALYST, var0, var1);
        this.blockPosSource = new BlockPositionSource(this.worldPosition);
        this.sculkSpreader = SculkSpreader.createLevelSpreader();
    }

    @Override
    public boolean handleEventsImmediately() {
        return true;
    }

    @Override
    public PositionSource getListenerSource() {
        return this.blockPosSource;
    }

    @Override
    public int getListenerRadius() {
        return 8;
    }

    @Override
    public boolean handleGameEvent(WorldServer var0, GameEvent.b var1) {
        Entity entity;
        if (this.isRemoved()) {
            return false;
        }
        GameEvent.a var2 = var1.context();
        if (var1.gameEvent() == GameEvent.ENTITY_DIE && (entity = var2.sourceEntity()) instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)entity;
            if (!var3.wasExperienceConsumed()) {
                int var4 = var3.getExperienceReward();
                if (var3.shouldDropExperience() && var4 > 0) {
                    this.sculkSpreader.addCursors(new BlockPosition(var1.source().relative(EnumDirection.UP, 0.5)), var4);
                    EntityLiving var5 = var3.getLastHurtByMob();
                    if (var5 instanceof EntityPlayer) {
                        EntityPlayer var6 = (EntityPlayer)var5;
                        DamageSource var7 = var3.getLastDamageSource() == null ? DamageSource.playerAttack(var6) : var3.getLastDamageSource();
                        CriterionTriggers.KILL_MOB_NEAR_SCULK_CATALYST.trigger(var6, var2.sourceEntity(), var7);
                    }
                }
                var3.skipDropExperience();
                SculkCatalystBlock.bloom(var0, this.worldPosition, this.getBlockState(), var0.getRandom());
            }
            return true;
        }
        return false;
    }

    public static void serverTick(World var0, BlockPosition var1, IBlockData var2, SculkCatalystBlockEntity var3) {
        var3.sculkSpreader.updateCursors(var0, var1, var0.getRandom(), true);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.sculkSpreader.load(var0);
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        this.sculkSpreader.save(var0);
        super.saveAdditional(var0);
    }

    @VisibleForTesting
    public SculkSpreader getSculkSpreader() {
        return this.sculkSpreader;
    }

    private static /* synthetic */ Integer a(SculkSpreader.a var0) {
        return 1;
    }
}

