/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class LightningRodBlock
extends RodBlock
implements IBlockWaterlogged {
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    private static final int ACTIVATION_TICKS = 8;
    public static final int RANGE = 128;
    private static final int SPARK_CYCLE = 200;

    public LightningRodBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.UP)).setValue(WATERLOGGED, false)).setValue(POWERED, false));
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        boolean var2 = var1.getType() == FluidTypes.WATER;
        return (IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getClickedFace())).setValue(WATERLOGGED, var2);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getDirectSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(POWERED).booleanValue() && var0.getValue(FACING) == var3) {
            return 15;
        }
        return 0;
    }

    public void onLightningStrike(IBlockData var0, World var1, BlockPosition var2) {
        var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, true), 3);
        this.updateNeighbours(var0, var1, var2);
        var1.scheduleTick(var2, this, 8);
        var1.levelEvent(3002, var2, var0.getValue(FACING).getAxis().ordinal());
    }

    private void updateNeighbours(IBlockData var0, World var1, BlockPosition var2) {
        var1.updateNeighborsAt(var2.relative(var0.getValue(FACING).getOpposite()), this);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 3);
        this.updateNeighbours(var0, var1, var2);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var1.isThundering() || (long)var1.random.nextInt(200) > var1.getGameTime() % 200L || var2.getY() != var1.getHeight(HeightMap.Type.WORLD_SURFACE, var2.getX(), var2.getZ()) - 1) {
            return;
        }
        ParticleUtils.spawnParticlesAlongAxis(var0.getValue(FACING).getAxis(), var1, var2, 0.125, Particles.ELECTRIC_SPARK, UniformInt.of(1, 2));
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(var0, var1, var2);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(POWERED).booleanValue() && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            var1.setBlock(var2, (IBlockData)var0.setValue(POWERED, false), 18);
        }
    }

    @Override
    public void onProjectileHit(World var0, IBlockData var1, MovingObjectPositionBlock var2, IProjectile var3) {
        BlockPosition var4;
        if (var0.isThundering() && var3 instanceof EntityThrownTrident && ((EntityThrownTrident)var3).isChanneling() && var0.canSeeSky(var4 = var2.getBlockPos())) {
            EntityLightning var5 = EntityTypes.LIGHTNING_BOLT.create(var0);
            var5.moveTo(Vec3D.atBottomCenterOf(var4.above()));
            Entity var6 = var3.getOwner();
            var5.setCause(var6 instanceof EntityPlayer ? (EntityPlayer)var6 : null);
            var0.addFreshEntity(var5);
            var0.playSound(null, var4, SoundEffects.TRIDENT_THUNDER, SoundCategory.WEATHER, 5.0f, 1.0f);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, WATERLOGGED);
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }
}

