/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;

public interface IBlockWaterlogged
extends IFluidSource,
IFluidContainer {
    @Override
    default public boolean canPlaceLiquid(IBlockAccess var0, BlockPosition var1, IBlockData var2, FluidType var3) {
        return var2.getValue(BlockProperties.WATERLOGGED) == false && var3 == FluidTypes.WATER;
    }

    @Override
    default public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        if (!var2.getValue(BlockProperties.WATERLOGGED).booleanValue() && var3.getType() == FluidTypes.WATER) {
            if (!var0.isClientSide()) {
                var0.setBlock(var1, (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, true), 3);
                var0.scheduleTick(var1, var3.getType(), var3.getType().getTickDelay(var0));
            }
            return true;
        }
        return false;
    }

    @Override
    default public ItemStack pickupBlock(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        if (var2.getValue(BlockProperties.WATERLOGGED).booleanValue()) {
            var0.setBlock(var1, (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, false), 3);
            if (!var2.canSurvive(var0, var1)) {
                var0.destroyBlock(var1, true);
            }
            return new ItemStack(Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    @Override
    default public Optional<SoundEffect> getPickupSound() {
        return FluidTypes.WATER.getPickupSound();
    }
}

