/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class EnumBlockSupport
extends Enum<EnumBlockSupport> {
    public static final /* enum */ EnumBlockSupport FULL = new EnumBlockSupport(){

        @Override
        public boolean isSupporting(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
            return Block.isFaceFull(var0.getBlockSupportShape(var1, var2), var3);
        }
    };
    public static final /* enum */ EnumBlockSupport CENTER = new EnumBlockSupport(){
        private final int CENTER_SUPPORT_WIDTH = 1;
        private final VoxelShape CENTER_SUPPORT_SHAPE = Block.box(7.0, 0.0, 7.0, 9.0, 10.0, 9.0);

        @Override
        public boolean isSupporting(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
            return !VoxelShapes.joinIsNotEmpty(var0.getBlockSupportShape(var1, var2).getFaceShape(var3), this.CENTER_SUPPORT_SHAPE, OperatorBoolean.ONLY_SECOND);
        }
    };
    public static final /* enum */ EnumBlockSupport RIGID = new EnumBlockSupport(){
        private final int RIGID_SUPPORT_WIDTH = 2;
        private final VoxelShape RIGID_SUPPORT_SHAPE = VoxelShapes.join(VoxelShapes.block(), Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0), OperatorBoolean.ONLY_FIRST);

        @Override
        public boolean isSupporting(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
            return !VoxelShapes.joinIsNotEmpty(var0.getBlockSupportShape(var1, var2).getFaceShape(var3), this.RIGID_SUPPORT_SHAPE, OperatorBoolean.ONLY_SECOND);
        }
    };
    private static final /* synthetic */ EnumBlockSupport[] d;

    public static EnumBlockSupport[] values() {
        return (EnumBlockSupport[])d.clone();
    }

    public static EnumBlockSupport valueOf(String var0) {
        return Enum.valueOf(EnumBlockSupport.class, var0);
    }

    public abstract boolean isSupporting(IBlockData var1, IBlockAccess var2, BlockPosition var3, EnumDirection var4);

    private static /* synthetic */ EnumBlockSupport[] a() {
        return new EnumBlockSupport[]{FULL, CENTER, RIGID};
    }

    static {
        d = EnumBlockSupport.a();
    }
}

