/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.box(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    public static final BlockStateBoolean BERRIES = BlockProperties.BERRIES;

    public static EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2) {
        if (var0.getValue(BERRIES).booleanValue()) {
            Block.popResource(var1, var2, new ItemStack(Items.GLOW_BERRIES, 1));
            float var3 = MathHelper.randomBetween(var1.random, 0.8f, 1.2f);
            var1.playSound(null, var2, SoundEffects.CAVE_VINES_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, var3);
            var1.setBlock(var2, (IBlockData)var0.setValue(BERRIES, false), 2);
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean hasGlowBerries(IBlockData var0) {
        return var0.hasProperty(BERRIES) && var0.getValue(BERRIES) != false;
    }

    public static ToIntFunction<IBlockData> emission(int var0) {
        return var1 -> var1.getValue(BlockProperties.BERRIES) != false ? var0 : 0;
    }
}

