/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.item.ItemWearable;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.predicate.MaterialPredicate;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.Material;

public class BlockPumpkinCarved
extends BlockFacingHorizontal
implements ItemWearable {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    @Nullable
    private ShapeDetector snowGolemBase;
    @Nullable
    private ShapeDetector snowGolemFull;
    @Nullable
    private ShapeDetector ironGolemBase;
    @Nullable
    private ShapeDetector ironGolemFull;
    private static final Predicate<IBlockData> PUMPKINS_PREDICATE = var0 -> var0 != null && (var0.is(Blocks.CARVED_PUMPKIN) || var0.is(Blocks.JACK_O_LANTERN));

    protected BlockPumpkinCarved(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.trySpawnGolem(var1, var2);
    }

    public boolean canSpawnGolem(IWorldReader var0, BlockPosition var1) {
        return this.getOrCreateSnowGolemBase().find(var0, var1) != null || this.getOrCreateIronGolemBase().find(var0, var1) != null;
    }

    /*
     * WARNING - void declaration
     */
    private void trySpawnGolem(World var0, BlockPosition var1) {
        block9: {
            ShapeDetector.ShapeDetectorCollection var2;
            block8: {
                Object var4;
                var2 = this.getOrCreateSnowGolemFull().find(var0, var1);
                if (var2 == null) break block8;
                for (int var3 = 0; var3 < this.getOrCreateSnowGolemFull().getHeight(); ++var3) {
                    var4 = var2.getBlock(0, var3, 0);
                    var0.setBlock(((ShapeDetectorBlock)var4).getPos(), Blocks.AIR.defaultBlockState(), 2);
                    var0.levelEvent(2001, ((ShapeDetectorBlock)var4).getPos(), Block.getId(((ShapeDetectorBlock)var4).getState()));
                }
                EntitySnowman var3 = EntityTypes.SNOW_GOLEM.create(var0);
                var4 = var2.getBlock(0, 2, 0).getPos();
                var3.moveTo((double)((BaseBlockPosition)var4).getX() + 0.5, (double)((BaseBlockPosition)var4).getY() + 0.05, (double)((BaseBlockPosition)var4).getZ() + 0.5, 0.0f, 0.0f);
                var0.addFreshEntity(var3);
                for (EntityPlayer entityPlayer : var0.getEntitiesOfClass(EntityPlayer.class, var3.getBoundingBox().inflate(5.0))) {
                    CriterionTriggers.SUMMONED_ENTITY.trigger(entityPlayer, var3);
                }
                for (int var5 = 0; var5 < this.getOrCreateSnowGolemFull().getHeight(); ++var5) {
                    ShapeDetectorBlock shapeDetectorBlock = var2.getBlock(0, var5, 0);
                    var0.blockUpdated(shapeDetectorBlock.getPos(), Blocks.AIR);
                }
                break block9;
            }
            var2 = this.getOrCreateIronGolemFull().find(var0, var1);
            if (var2 == null) break block9;
            for (int var3 = 0; var3 < this.getOrCreateIronGolemFull().getWidth(); ++var3) {
                for (int var4 = 0; var4 < this.getOrCreateIronGolemFull().getHeight(); ++var4) {
                    ShapeDetectorBlock var5 = var2.getBlock(var3, var4, 0);
                    var0.setBlock(var5.getPos(), Blocks.AIR.defaultBlockState(), 2);
                    var0.levelEvent(2001, var5.getPos(), Block.getId(var5.getState()));
                }
            }
            BlockPosition var3 = var2.getBlock(1, 2, 0).getPos();
            EntityIronGolem var4 = EntityTypes.IRON_GOLEM.create(var0);
            var4.setPlayerCreated(true);
            var4.moveTo((double)var3.getX() + 0.5, (double)var3.getY() + 0.05, (double)var3.getZ() + 0.5, 0.0f, 0.0f);
            var0.addFreshEntity(var4);
            for (EntityPlayer entityPlayer : var0.getEntitiesOfClass(EntityPlayer.class, var4.getBoundingBox().inflate(5.0))) {
                CriterionTriggers.SUMMONED_ENTITY.trigger(entityPlayer, var4);
            }
            for (int var5 = 0; var5 < this.getOrCreateIronGolemFull().getWidth(); ++var5) {
                void var7_20;
                boolean bl = false;
                while (var7_20 < this.getOrCreateIronGolemFull().getHeight()) {
                    ShapeDetectorBlock var7 = var2.getBlock(var5, (int)var7_20, 0);
                    var0.blockUpdated(var7.getPos(), Blocks.AIR);
                    ++var7_20;
                }
            }
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }

    private ShapeDetector getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = ShapeDetectorBuilder.start().aisle(" ", "#", "#").where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemBase;
    }

    private ShapeDetector getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = ShapeDetectorBuilder.start().aisle("^", "#", "#").where('^', ShapeDetectorBlock.hasState(PUMPKINS_PREDICATE)).where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemFull;
    }

    private ShapeDetector getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = ShapeDetectorBuilder.start().aisle("~ ~", "###", "~#~").where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', ShapeDetectorBlock.hasState(MaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return this.ironGolemBase;
    }

    private ShapeDetector getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = ShapeDetectorBuilder.start().aisle("~^~", "###", "~#~").where('^', ShapeDetectorBlock.hasState(PUMPKINS_PREDICATE)).where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', ShapeDetectorBlock.hasState(MaterialPredicate.forMaterial(Material.AIR))).build();
        }
        return this.ironGolemFull;
    }
}

