/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;

public class BlockPlant
extends Block {
    protected BlockPlant(BlockBase.Info var0) {
        super(var0);
    }

    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(TagsBlock.DIRT) || var0.is(Blocks.FARMLAND);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        return this.mayPlaceOn(var1.getBlockState(var3), var1, var3);
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.getFluidState().isEmpty();
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        if (var3 == PathMode.AIR && !this.hasCollision) {
            return true;
        }
        return super.isPathfindable(var0, var1, var2, var3);
    }
}

