/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockNetherWart
extends BlockPlant {
    public static final int MAX_AGE = 3;
    public static final BlockStateInteger AGE = BlockProperties.AGE_3;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box(0.0, 0.0, 0.0, 16.0, 5.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 11.0, 16.0), Block.box(0.0, 0.0, 0.0, 16.0, 14.0, 16.0)};

    protected BlockNetherWart(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE_BY_AGE[var0.getValue(AGE)];
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.is(Blocks.SOUL_SAND);
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(AGE) < 3;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4 = var0.getValue(AGE);
        if (var4 < 3 && var3.nextInt(10) == 0) {
            var0 = (IBlockData)var0.setValue(AGE, var4 + 1);
            var1.setBlock(var2, var0, 2);
        }
    }

    @Override
    public ItemStack getCloneItemStack(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        return new ItemStack(Items.NETHER_WART);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }
}

