/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Supplier<Holder<? extends WorldGenFeatureConfigured<?, ?>>> featureSupplier;

    public BlockMushroom(BlockBase.Info var0, Supplier<Holder<? extends WorldGenFeatureConfigured<?, ?>>> var1) {
        super(var0);
        this.featureSupplier = var1;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(25) == 0) {
            int var4 = 5;
            int var5 = 4;
            for (BlockPosition var7 : BlockPosition.betweenClosed(var2.offset(-4, -1, -4), var2.offset(4, 1, 4))) {
                if (!var1.getBlockState(var7).is(this) || --var4 > 0) continue;
                return;
            }
            BlockPosition var6 = var2.offset(var3.nextInt(3) - 1, var3.nextInt(2) - var3.nextInt(2), var3.nextInt(3) - 1);
            for (int var7 = 0; var7 < 4; ++var7) {
                if (var1.isEmptyBlock(var6) && var0.canSurvive(var1, var6)) {
                    var2 = var6;
                }
                var6 = var2.offset(var3.nextInt(3) - 1, var3.nextInt(2) - var3.nextInt(2), var3.nextInt(3) - 1);
            }
            if (var1.isEmptyBlock(var6) && var0.canSurvive(var1, var6)) {
                var1.setBlock(var6, var0, 2);
            }
        }
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return var0.isSolidRender(var1, var2);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.below();
        IBlockData var4 = var1.getBlockState(var3);
        if (var4.is(TagsBlock.MUSHROOM_GROW_BLOCK)) {
            return true;
        }
        return var1.getRawBrightness(var2, 0) < 13 && this.mayPlaceOn(var4, var1, var3);
    }

    public boolean growMushroom(WorldServer var0, BlockPosition var1, IBlockData var2, RandomSource var3) {
        var0.removeBlock(var1, false);
        if (this.featureSupplier.get().value().place(var0, var0.getChunkSource().getGenerator(), var3, var1)) {
            return true;
        }
        var0.setBlock(var1, var2, 3);
        return false;
    }

    @Override
    public boolean isValidBonemealTarget(IBlockAccess var0, BlockPosition var1, IBlockData var2, boolean var3) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return (double)var1.nextFloat() < 0.4;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.growMushroom(var0, var2, var3, var1);
    }
}

