/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockGrassPath
extends Block {
    protected static final VoxelShape SHAPE = BlockSoil.SHAPE;

    protected BlockGrassPath(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        if (!this.defaultBlockState().canSurvive(var0.getLevel(), var0.getClickedPos())) {
            return Block.pushEntitiesUp(this.defaultBlockState(), Blocks.DIRT.defaultBlockState(), var0.getLevel(), var0.getClickedPos());
        }
        return super.getStateForPlacement(var0);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP && !var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        BlockSoil.turnToDirt(var0, var1, var2);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.above());
        return !var3.getMaterial().isSolid() || var3.getBlock() instanceof BlockFenceGate;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

