/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public abstract class BlockFurnace
extends BlockTileEntity {
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean LIT = BlockProperties.LIT;

    protected BlockFurnace(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(LIT, false));
    }

    @Override
    public EnumInteractionResult use(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, EnumHand var4, MovingObjectPositionBlock var5) {
        if (var1.isClientSide) {
            return EnumInteractionResult.SUCCESS;
        }
        this.openContainer(var1, var2, var3);
        return EnumInteractionResult.CONSUME;
    }

    protected abstract void openContainer(World var1, BlockPosition var2, EntityHuman var3);

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, EntityLiving var3, ItemStack var4) {
        TileEntity var5;
        if (var4.hasCustomHoverName() && (var5 = var0.getBlockEntity(var1)) instanceof TileEntityFurnace) {
            ((TileEntityFurnace)var5).setCustomName(var4.getHoverName());
        }
    }

    @Override
    public void onRemove(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.is(var3.getBlock())) {
            return;
        }
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityFurnace) {
            if (var1 instanceof WorldServer) {
                InventoryUtils.dropContents(var1, var2, (IInventory)((TileEntityFurnace)var5));
                ((TileEntityFurnace)var5).getRecipesToAwardAndPopExperience((WorldServer)var1, Vec3D.atCenterOf(var2));
            }
            var1.updateNeighbourForOutputSignal(var2, this);
        }
        super.onRemove(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2) {
        return Container.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    public EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.MODEL;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, LIT);
    }

    @Nullable
    protected static <T extends TileEntity> BlockEntityTicker<T> createFurnaceTicker(World var0, TileEntityTypes<T> var1, TileEntityTypes<? extends TileEntityFurnace> var2) {
        return var0.isClientSide ? null : BlockFurnace.createTickerHelper(var1, var2, TileEntityFurnace::serverTick);
    }
}

